// To parse this JSON data, do
//
//     final newBrandResponseModel = newBrandResponseModelFromJson(jsonString);

import 'dart:convert';

NewBrandResponseModel newBrandResponseModelFromJson(String str) =>
    NewBrandResponseModel.fromJson(json.decode(str));

String newBrandResponseModelToJson(NewBrandResponseModel data) =>
    json.encode(data.toJson());

class NewBrandResponseModel {
  final String? remark;
  final String? status;
  final List<String>? message;
  final Data? data;

  NewBrandResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory NewBrandResponseModel.fromJson(Map<String, dynamic> json) =>
      NewBrandResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message":
            message == null ? [] : List<dynamic>.from(message!.map((x) => x)),
        "data": data?.toJson(),
      };
}

class Data {
  final Brand? brand;

  Data({
    this.brand,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        brand: json["brand"] == null ? null : Brand.fromJson(json["brand"]),
      );

  Map<String, dynamic> toJson() => {
        "brand": brand?.toJson(),
      };
}

class Brand {
  final String? name;
  final String? updatedAt;
  final String? createdAt;
  final String? id;
  final String? imageSrc;

  Brand({
    this.name,
    this.updatedAt,
    this.createdAt,
    this.id,
    this.imageSrc,
  });

  factory Brand.fromJson(Map<String, dynamic> json) => Brand(
        name: json["name"].toString(),
        updatedAt: json["updated_at"].toString(),
        createdAt: json["created_at"].toString(),
        id: json["id"].toString(),
        imageSrc: json["image_src"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "name": name,
        "updated_at": updatedAt,
        "created_at": createdAt,
        "id": id,
        "image_src": imageSrc,
      };
}
