// To parse this JSON data, do
//
//     final attributeResponseModel = attributeResponseModelFromJson(jsonString);

import 'dart:convert';

AttributeResponseModel attributeResponseModelFromJson(String str) =>
    AttributeResponseModel.fromJson(json.decode(str));

String attributeResponseModelToJson(AttributeResponseModel data) =>
    json.encode(data.toJson());

class AttributeResponseModel {
  String? remark;
  String? status;
  List<String>? message;
  Data? data;

  AttributeResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory AttributeResponseModel.fromJson(Map<String, dynamic> json) =>
      AttributeResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message":
            message == null ? [] : List<dynamic>.from(message!.map((x) => x)),
        "data": data?.toJson(),
      };
}

class Data {
  List<AttributeData>? attributes;

  Data({
    this.attributes,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        attributes: json["attributes"] == null
            ? []
            : List<AttributeData>.from(
                json["attributes"]!.map((x) => AttributeData.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "attributes": attributes == null
            ? []
            : List<dynamic>.from(attributes!.map((x) => x.toJson())),
      };
}

class AttributeData {
  String? id;
  String? name;
  String? status;
  String? deletedAt;
  String? createdAt;
  String? updatedAt;

  AttributeData({
    this.id,
    this.name,
    this.status,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
  });

  factory AttributeData.fromJson(Map<String, dynamic> json) => AttributeData(
        id: json["id"].toString(),
        name: json["name"].toString(),
        status: json["status"].toString(),
        deletedAt: json["deleted_at"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "status": status,
        "deleted_at": deletedAt,
        "created_at": createdAt,
        "updated_at": updatedAt,
      };
}
