import 'dart:convert';

import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/core/utils/my_strings.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/model/warehouse/update_warehoouse_response_model.dart';
import 'package:ovosale/data/model/warehouse/warehouse_data_model.dart';
import 'package:ovosale/data/model/warehouse/warehouse_response_model.dart';
import 'package:ovosale/data/model/warehouse/warehouse_status_update_response_model.dart';
import 'package:ovosale/data/repo/warehouse/warehouse_repo.dart';

class WarehouseController extends GetxController {
  WarehouseRepo warehouseRepo;
  WarehouseController({required this.warehouseRepo});

  final TextEditingController searchWarehouseController =
      TextEditingController();
  final TextEditingController warehouseNameController = TextEditingController();
  final TextEditingController contactNumberController = TextEditingController();
  final TextEditingController emailController = TextEditingController();
  final TextEditingController addressController = TextEditingController();
  final TextEditingController cityController = TextEditingController();
  final TextEditingController stateController = TextEditingController();
  final TextEditingController postCodeController = TextEditingController();

  List<WarehouseData> filteredWarehouseData = [];
  String warehouseImagePath = "";

  String nextPageUrl = "";
  int currentPage = 1;

  bool isLoading = false;

  getWarehouseData({bool isPagination = false}) async {
    if (isPagination == false) {
      currentPage = 0;
      isLoading = true;
      update();
    }

    currentPage = currentPage + 1;

    if (currentPage == 1) {
      filteredWarehouseData.clear();
    }

    String pram = "";

    pram += "?page=$currentPage";
    pram += "&search=${searchWarehouseController.text}";

    update();
    ResponseModel responseModel = await warehouseRepo.getWarehouseData(pram);
    if (responseModel.statusCode == 200) {
      WarehouseResponseModel model = warehouseResponseModelFromJson(
          jsonEncode(responseModel.responseJson));
      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        filteredWarehouseData.addAll(model.data?.warehouses?.data ?? []);
        nextPageUrl = model.data?.warehouses?.nextPageUrl ?? "";

        isLoading = false;
        update();
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    isLoading = false;
    update();
  }

  bool hasNext() {
    return nextPageUrl.isNotEmpty && nextPageUrl != 'null' ? true : false;
  }

  getWarehouseFieldData(int index) {
    final selectedWarehouse = filteredWarehouseData[index];
    {
      warehouseNameController.text = selectedWarehouse.name.toString();
      contactNumberController.text = selectedWarehouse.contactNumber.toString();

      addressController.text = selectedWarehouse.address.toString();
      cityController.text = selectedWarehouse.city.toString();
      stateController.text = selectedWarehouse.state.toString();
      postCodeController.text = selectedWarehouse.postcode.toString();
    }
  }

  WarehouseDataModel getFieldData() {
    WarehouseDataModel model = WarehouseDataModel(
        warehouseName: warehouseNameController.text,
        contact: contactNumberController.text,
        address: addressController.text,
        city: cityController.text,
        email: emailController.text,
        postCode: postCodeController.text,
        state: stateController.text);
    return model;
  }

  bool isSubmitting = false;
  void updateWarehouse(String warehouseId) async {
    isSubmitting = true;
    WarehouseDataModel model = getFieldData();
    update();
    try {
      ResponseModel responseModel =
          await warehouseRepo.updateWarehouseRepo(model, warehouseId);

      if (responseModel.statusCode == 200) {
        UpdateWarehouseResponseModel model =
            updateWarehouseResponseModelFromJson(
                jsonEncode(responseModel.responseJson));

        if (model.status.toString() ==
            MyStrings.success.toString().toLowerCase()) {
          await getWarehouseData(isPagination: false);
          Get.back();
          CustomSnackBar.success(
              successList: model.message ?? [MyStrings.succeed.tr]);
        } else {
          CustomSnackBar.error(
              errorList: model.message ?? [MyStrings.requestFail.tr]);
        }
        isSubmitting = false;
        update();
      } else {
        CustomSnackBar.error(errorList: [responseModel.message.tr]);
      }
    } catch (e) {
      isSubmitting = false;
      update();
    }
  }

  void filterWarehouse(String query) {
    if (query.isEmpty) {
      filteredWarehouseData = List.from(filteredWarehouseData);
    } else {
      filteredWarehouseData = filteredWarehouseData
          .where((category) =>
              category.name!.toLowerCase().contains(query.toLowerCase()))
          .toList();
    }
    update();
  }

  String warehouseUpdateLoadingIndex = "-1";
  void changeStatus(String id, int index, bool value) async {
    warehouseUpdateLoadingIndex = id;
    update();

    ResponseModel responseModel =
        await warehouseRepo.warehouseStatusChangeData(id);

    if (responseModel.statusCode == 200) {
      WarehouseStatusChangeResponseModel model =
          warehouseStatusChangeResponseModelFromJson(
              jsonEncode(responseModel.responseJson));

      if (model.status.toString().toLowerCase() == "success") {
        if (!value) {
          filteredWarehouseData[index].status = "1";
        } else {
          filteredWarehouseData[index].status = "0";
        }
        CustomSnackBar.success(successList: [model.message.toString()]);
      } else {
        CustomSnackBar.error(errorList: model.message ?? ["Request failed"]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }

    warehouseUpdateLoadingIndex = "-1";
    update();
  }
}
