import 'dart:convert';

import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/core/utils/my_strings.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/model/warehouse/add_warehouse_response_model.dart';
import 'package:ovosale/data/model/warehouse/warehouse_data_model.dart';
import 'package:ovosale/data/repo/new_warehouse/new_warehouse_repo.dart';

class NewWarehouseController extends GetxController {
  NewWarehouseRepo newWarehouseRepo;
  NewWarehouseController({required this.newWarehouseRepo});
  String selectedValue = "Option 1";

  final TextEditingController warehouseNameController = TextEditingController();
  final TextEditingController contactNumberController = TextEditingController();
  final TextEditingController emailController = TextEditingController();
  final TextEditingController addressController = TextEditingController();
  final TextEditingController cityController = TextEditingController();
  final TextEditingController stateController = TextEditingController();
  final TextEditingController postCodeController = TextEditingController();

  List<Map<String, String>> dropdownData = [
    {"label": "Option 1"},
    {"label": "Option 2"},
    {"label": "Option 3"},
  ];

  bool isSubmitting = false;

  WarehouseDataModel getWarehouseData() {
    WarehouseDataModel model = WarehouseDataModel(
        warehouseName: warehouseNameController.text,
        contact: contactNumberController.text,
        address: addressController.text,
        city: cityController.text,
        email: emailController.text,
        postCode: postCodeController.text,
        state: stateController.text);

    return model;
  }

  void createWarehouse() async {
    isSubmitting = true;
    WarehouseDataModel model = getWarehouseData();
    update();

    ResponseModel responseModel = await newWarehouseRepo.createWarehouse(model);

    if (responseModel.statusCode == 200) {
      AddWarehouseResponseModel model = addWarehouseResponseModelFromJson(
          jsonEncode(responseModel.responseJson));

      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        Get.back();
        isSubmitting = false;
        update();
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    isSubmitting = false;
    update();
  }
}
