import 'dart:convert';

import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/core/utils/my_strings.dart';
import 'package:ovosale/data/model/auth/two_factor/two_factor_data_model.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/model/variant/variant_model.dart';
import 'package:ovosale/data/model/variant/variant_status_update_response_model.dart';
import 'package:ovosale/data/model/variant/variant_update_response_model.dart'
    as prefix;
import 'package:ovosale/data/repo/variant/variant_repo.dart';

class VariantController extends GetxController {
  VariantRepo variantRepo;
  VariantController({required this.variantRepo});

  final TextEditingController methodNameController = TextEditingController();

  Variants? variantsData;
  List<Attribute> variantDataAttributeList = [];
  List<Attribute> filteredVariantDataList = [];
  String categoryImagePath = "";
  TextEditingController variantSearchController = TextEditingController();
  String nextPageUrl = "";
  int currentPage = 1;
  bool isLoading = false;
  bool isSubmitting = false;
  String attributeId = "";
  String selectedValue = "Select one";
  TwoFactorCodeModel twoFactorCodeModel = TwoFactorCodeModel();

  getVariant({bool isPagination = false}) async {
    if (isPagination == false) {
      currentPage = 0;
      isLoading = true;
      update();
    }

    currentPage = currentPage + 1;

    if (currentPage == 1) {
      filteredVariantDataList.clear();
    }

    String pram = "";

    pram += "?page=$currentPage";
    pram += "&search=${variantSearchController.text}";

    update();
    ResponseModel responseModel = await variantRepo.getVariantData(pram);
    if (responseModel.statusCode == 200) {
      VariantResponseModel model =
          variantResponseModelFromJson(jsonEncode(responseModel.responseJson));
      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        variantDataAttributeList.clear();
        filteredVariantDataList.addAll(model.data?.variants?.data ?? []);
        nextPageUrl = model.data?.variants?.nextPageUrl ?? "";
        if (currentPage == 1) {
          variantDataAttributeList.add(Attribute(id: "0", name: "Select one"));
          variantDataAttributeList.addAll(model.data?.attributes ?? []);
        }
        isLoading = false;
        update();
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    isLoading = false;
    update();
  }

  bool hasNext() {
    return nextPageUrl.isNotEmpty && nextPageUrl != 'null' ? true : false;
  }

  void getSelectedItemValue(String attributeId) {
    Attribute attribute = variantDataAttributeList.firstWhere(
      (attribute) => attribute.id == attributeId,
      orElse: () => Attribute(id: '0', name: 'Unknown'),
    );

    bool exists = variantDataAttributeList.any(
      (attr) => attr.name == attribute.name,
    );

    selectedValue = exists
        ? attribute.name.toString()
        : variantDataAttributeList.first.name.toString();
    update();
  }

  void updateVariant(
    String variantId,
    String attributeIds,
  ) async {
    isSubmitting = true;
    update();

    try {
      ResponseModel responseModel = await variantRepo.updateVariant(
          methodNameController.text, variantId, attributeIds);

      if (responseModel.statusCode == 200) {
        prefix.VariantUpdateResponseModel model =
            prefix.variantUpdateResponseModelFromJson(
                jsonEncode(responseModel.responseJson));

        if (model.status.toString() ==
            MyStrings.success.toString().toLowerCase()) {
          Get.back();
          await getVariant(isPagination: false);

          CustomSnackBar.success(
              successList: model.message ?? [MyStrings.succeed.tr]);
          update();
        } else {
          CustomSnackBar.error(
              errorList: model.message ?? [MyStrings.requestFail.tr]);
        }
      } else {
        CustomSnackBar.error(errorList: [responseModel.message.tr]);
      }
      isSubmitting = false;
      update();
    } catch (e) {
      isSubmitting = false;
      update();
    }
  }

  String attributeUpdateLoadingIndex = "-1";
  void changeStatus(String id, int index, bool value) async {
    attributeUpdateLoadingIndex = id;
    update();

    ResponseModel responseModel = await variantRepo.variantStatusChangeData(id);

    if (responseModel.statusCode == 200) {
      VariantStatusChangeResponseModel model =
          variantStatusChangeResponseModelFromJson(
              jsonEncode(responseModel.responseJson));

      if (model.status.toString().toLowerCase() == "success") {
        if (!value) {
          filteredVariantDataList[index].status = "1";
        } else {
          filteredVariantDataList[index].status = "0";
        }
        CustomSnackBar.success(successList: [model.message.toString()]);
      } else {
        CustomSnackBar.error(errorList: model.message ?? ["Request failed"]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }

    attributeUpdateLoadingIndex = "-1";
    update();
  }
}
