import 'dart:convert';

import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/core/utils/my_strings.dart';
import 'package:ovosale/data/model/attribute/attribute_response_model.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/model/variant/create_variant_model.dart';
import 'package:ovosale/data/repo/new_variant/new_variant_repo.dart';

class NewVariantController extends GetxController {
  NewVariantRepo newVariantRepo;
  NewVariantController({required this.newVariantRepo});
  String categoryId = "";
  String variantName = "";
  String selectedValue = "Select one";

  List<AttributeData> categoryDataList = [];

  final TextEditingController variantNameController = TextEditingController();
  bool submitLoading = false;
  bool isLoading = false;
  void createVariant() async {
    submitLoading = true;

    update();

    ResponseModel responseModel = await newVariantRepo.createVariant(
      variantNameController.text,
      categoryId,
    );

    if (responseModel.statusCode == 200) {
      CreateVariantResponseModel model = createVariantResponseModelFromJson(
          jsonEncode(responseModel.responseJson));

      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        Get.back();
        submitLoading = false;
        update();
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    submitLoading = false;
    update();
  }

  void getAttributes() async {
    categoryDataList = [];
    isLoading = true;
    update();

    ResponseModel responseModel = await newVariantRepo.getAttributeData();

    if (responseModel.statusCode == 200) {
      AttributeResponseModel model = attributeResponseModelFromJson(
          jsonEncode(responseModel.responseJson));

      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        categoryDataList.add(AttributeData(name: "Select one"));
        categoryDataList.addAll(model.data?.attributes ?? []);

        update();
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    isLoading = false;
    update();
  }
}
