import 'dart:convert';

import 'package:flutter/cupertino.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/core/utils/my_strings.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/model/unit/unit_data_respone_model.dart';
import 'package:ovosale/data/model/unit/unit_status_change_response_model.dart';
import 'package:ovosale/data/model/unit/unit_update_response_model.dart';
import 'package:ovosale/data/repo/unit/unit_repo.dart';

class UnitController extends GetxController {
  UnitRepo unitRepo;
  UnitController({required this.unitRepo});
  List<UnitData> unitDataList = [];
  List<UnitData> filteredUnitDataList = [];
  String categoryImagePath = "";
  String nextPageUrl = "";
  int currentPage = 1;

  TextEditingController unitNameController = TextEditingController();
  TextEditingController unitShortNameController = TextEditingController();
  TextEditingController unitSearchController = TextEditingController();

  bool isLoading = false;
  bool isSubmitting = false;

  bool hasNext() {
    return nextPageUrl.isNotEmpty && nextPageUrl != 'null' ? true : false;
  }

  getUnitData({bool isPagination = false}) async {
    if (isPagination == false) {
      currentPage = 0;
      isLoading = true;
      update();
    }

    currentPage = currentPage + 1;

    if (currentPage == 1) {
      filteredUnitDataList.clear();
    }

    String pram = "";

    pram += "?page=$currentPage";
    pram += "&search=${unitSearchController.text}";

    update();
    ResponseModel responseModel = await unitRepo.getUnitData(pram);
    if (responseModel.statusCode == 200) {
      UnitDataResponseModel model =
          unitDataResponseModelFromJson(jsonEncode(responseModel.responseJson));
      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        filteredUnitDataList.addAll(model.data?.units?.data ?? []);

        nextPageUrl = model.data?.units?.nextPageUrl ?? "";

        isLoading = false;
        update();
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    isLoading = false;
    update();
  }

  void updateUnit(String id) async {
    isSubmitting = true;
    update();

    ResponseModel responseModel = await unitRepo.updateUnit(
        unitNameController.text, id, unitShortNameController.text);

    if (responseModel.statusCode == 200) {
      UnitUpdateResponseModel model = unitUpdateResponseModelFromJson(
          jsonEncode(responseModel.responseJson));
      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        await getUnitData();
        Get.back();
        CustomSnackBar.success(
            successList: model.message ?? [MyStrings.success.toString()]);

        isLoading = false;

        update();
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    isSubmitting = false;
    update();
  }

  bool statusLoading = false;
  String warehouseUpdateLoadingIndex = "-1";
  void changeStatus(String id, int index, bool value) async {
    warehouseUpdateLoadingIndex = id;
    update();

    ResponseModel responseModel = await unitRepo.unitStatusChangeRepo(id);

    if (responseModel.statusCode == 200) {
      UnitStatusChangeResponseModel model =
          unitStatusChangeResponseModelFromJson(
              jsonEncode(responseModel.responseJson));

      if (model.status.toString().toLowerCase() == "success") {
        if (!value) {
          filteredUnitDataList[index].status = "1";
        } else {
          filteredUnitDataList[index].status = "0";
        }
        CustomSnackBar.success(successList: [model.message.toString()]);
      } else {
        CustomSnackBar.error(errorList: model.message ?? ["Request failed"]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }

    warehouseUpdateLoadingIndex = "-1";
    update();
  }
}
