import 'dart:convert';

import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/model/unit/unit_create_response_model.dart';
import 'package:ovosale/data/repo/unit/new_unit_repo.dart';

class NewUnitController extends GetxController {
  NewUnitRepo newUnitRepo;
  NewUnitController({required this.newUnitRepo});

  TextEditingController unitNameController = TextEditingController();
  TextEditingController unitShortNameController = TextEditingController();

  bool submitLoading = false;

  void submitUnitData() async {
    submitLoading = true;
    update();

    ResponseModel responseModel = await newUnitRepo.createUnitRepo(
        unitNameController.text, unitShortNameController.text);

    if (responseModel.statusCode == 200) {
      UnitCreateResponseModel model = unitCreateResponseModelFromJson(
          jsonEncode(responseModel.responseJson));

      if (model.status.toString().toLowerCase() == "success") {
        Get.back();
        CustomSnackBar.success(successList: [model.message.toString()]);
      } else {
        CustomSnackBar.error(errorList: model.message ?? ["Request failed"]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }

    submitLoading = false;
    update();
  }
}
