import 'dart:convert';

import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/core/utils/my_strings.dart';
import 'package:ovosale/data/model/auth/two_factor/two_factor_data_model.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/model/tax/tax_data_response_model.dart';
import 'package:ovosale/data/model/tax/tax_status_update_response_model.dart';
import 'package:ovosale/data/model/variant/variant_update_response_model.dart'
    as prefix;
import 'package:ovosale/data/repo/tax/tax_repo.dart';

class TaxController extends GetxController {
  TaxRepo taxRepo;
  TaxController({required this.taxRepo});

  final TextEditingController taxNameController = TextEditingController();
  final TextEditingController taxPercentageController = TextEditingController();
  final TextEditingController searchTaxController = TextEditingController();

  Taxes? taxes;
  List<TaxData> filteredTaxDataList = [];
  String taxDataImagePath = "";

  bool isLoading = false;
  bool isSubmitting = false;
  String attributeId = "";
  String nextPageUrl = "";
  String selectedTaxId = "";
  int currentPage = 1;
  String selectedValue = "Select one";
  TwoFactorCodeModel twoFactorCodeModel = TwoFactorCodeModel();

  bool hasNext() {
    return nextPageUrl.isNotEmpty && nextPageUrl != 'null' ? true : false;
  }

  getTaxData({bool isPagination = false}) async {
    if (isPagination == false) {
      currentPage = 0;
      isLoading = true;
      update();
    }

    currentPage = currentPage + 1;

    if (currentPage == 1) {
      filteredTaxDataList.clear();
    }

    String pram = "";

    pram += "?page=$currentPage";
    pram += "&search=${searchTaxController.text}";

    update();
    ResponseModel responseModel = await taxRepo.getTaxData(pram);
    if (responseModel.statusCode == 200) {
      TaxDataResponseModel model =
          taxDataResponseModelFromJson(jsonEncode(responseModel.responseJson));
      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        filteredTaxDataList.addAll(model.data?.taxes?.data ?? []);
        nextPageUrl = model.data?.taxes?.nextPageUrl ?? "";

        isLoading = false;
        update();
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    isLoading = false;
    update();
  }

  String taxUpdateLoadingIndex = "-1";
  void changeStatus(String id, int index, bool value) async {
    taxUpdateLoadingIndex = id;
    update();

    ResponseModel responseModel = await taxRepo.taxStatusChangeData(
      id,
    );

    if (responseModel.statusCode == 200) {
      TaxStatusChangeResponseModel model = taxStatusChangeResponseModelFromJson(
          jsonEncode(responseModel.responseJson));

      if (model.status.toString().toLowerCase() == "success") {
        if (!value) {
          filteredTaxDataList[index].status = "1";
        } else {
          filteredTaxDataList[index].status = "0";
        }
        update();
        CustomSnackBar.success(successList: [model.message.toString()]);
      } else {
        CustomSnackBar.error(errorList: model.message ?? ["Request failed"]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    taxUpdateLoadingIndex = "-1";
    update();
  }

  getSelectedItemValue(int index) {
    taxNameController.text = filteredTaxDataList[index].name.toString();
    taxPercentageController.text =
        filteredTaxDataList[index].percentage.toString();
    update();
  }

  void updateTax() async {
    isSubmitting = true;
    update();

    ResponseModel responseModel = await taxRepo.updateTax(
        taxNameController.text, taxPercentageController.text, selectedTaxId);

    if (responseModel.statusCode == 200) {
      prefix.VariantUpdateResponseModel model =
          prefix.variantUpdateResponseModelFromJson(
              jsonEncode(responseModel.responseJson));

      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        await getTaxData(isPagination: false);

        Get.back();
        isLoading = false;
        update();
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    isSubmitting = false;
    update();
  }
}
