import 'dart:convert';

import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/core/utils/my_strings.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/model/tax/new_tax_response_model.dart';
import 'package:ovosale/data/repo/tax/new_tax_repo.dart';

class NewTaxController extends GetxController {
  NewTaxRepo newTaxRepo;
  NewTaxController({required this.newTaxRepo});
  String attributeId = "";
  String variantName = "";

  final TextEditingController taxNameController = TextEditingController();
  final TextEditingController percentController = TextEditingController();
  bool isSubmitting = false;
  void createNewTax() async {
    isSubmitting = true;

    update();

    ResponseModel responseModel = await newTaxRepo.createTax(
      taxNameController.text,
      percentController.text,
    );

    if (responseModel.statusCode == 200) {
      NewTaxResponseModel model =
          newTaxResponseModelFromJson(jsonEncode(responseModel.responseJson));

      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        Get.back();
        isSubmitting = false;
        update();
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    isSubmitting = false;
    update();
  }
}
