import 'dart:convert';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/core/utils/my_strings.dart';
import 'package:ovosale/data/model/auth/two_factor/two_factor_data_model.dart';
import 'package:ovosale/data/model/coupon/coupon_update_response_model.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/model/supplier/supplier_data.dart';
import 'package:ovosale/data/model/supplier/supplier_response_model.dart';
import 'package:ovosale/data/model/supplier/supplier_status_change_response_model.dart';
import 'package:ovosale/data/repo/supplier/supplier_repo.dart';
import 'package:ovosale/data/services/shared_pref_service.dart';

class SupplierController extends GetxController {
  SupplierRepo supplierRepo;
  SupplierController({required this.supplierRepo});

  final TextEditingController nameController = TextEditingController();
  final TextEditingController emailController = TextEditingController();
  final TextEditingController mobileController = TextEditingController();
  final TextEditingController addressController = TextEditingController();
  final TextEditingController cityController = TextEditingController();
  final TextEditingController stateController = TextEditingController();
  final TextEditingController countryController = TextEditingController();
  final TextEditingController zipController = TextEditingController();
  final TextEditingController postcodeController = TextEditingController();
  final TextEditingController companyNameController = TextEditingController();
  final TextEditingController searchSupplierController =
      TextEditingController();

  List<SuppliersData> filteredSupplierData = [];

  String selectedValue = "%";
  String discountType = "1";

  String nextPageUrl = "";
  int currentPage = 1;

  String categoryImagePath = "";

  bool hasNext() {
    return nextPageUrl.isNotEmpty && nextPageUrl != 'null' ? true : false;
  }

  getData(int index) {
    defaultCurrency = SharedPreferenceService.getString(
      SharedPreferenceService.defaultCurrencyKey,
    );

    update();
  }

  bool isLoading = false;
  bool isSubmitting = false;
  String defaultCurrency = "";
  String defaultCurrencySymbol = "";
  TwoFactorCodeModel twoFactorCodeModel = TwoFactorCodeModel();

  getSupplierData({bool isPagination = false}) async {
    if (isPagination == false) {
      currentPage = 0;
      isLoading = true;
      update();
    }

    currentPage = currentPage + 1;

    if (currentPage == 1) {
      filteredSupplierData.clear();
    }

    String pram = "";

    pram += "?page=$currentPage";
    pram += "&search=${searchSupplierController.text}";

    update();
    ResponseModel responseModel = await supplierRepo.getSupplierData(pram);
    if (responseModel.statusCode == 200) {
      SupplierDataResponseModel model = supplierDataResponseModelFromJson(
          jsonEncode(responseModel.responseJson));
      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        filteredSupplierData.addAll(model.data?.suppliers?.data ?? []);
        nextPageUrl = model.data?.suppliers?.nextPageUrl ?? "";

        isLoading = false;
        update();
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    isLoading = false;
    update();
  }

  getSelectedItemValue(int index) {
    final selectedSupplier = filteredSupplierData[index];
    {
      nameController.text = selectedSupplier.name.toString();
      emailController.text = selectedSupplier.email.toString() != "null"
          ? selectedSupplier.email.toString()
          : "";
      mobileController.text = selectedSupplier.mobile.toString() != "null"
          ? selectedSupplier.mobile.toString()
          : "";
      addressController.text = selectedSupplier.address.toString() != "null"
          ? selectedSupplier.address.toString()
          : "";
      cityController.text = selectedSupplier.city.toString() != "null"
          ? selectedSupplier.city.toString()
          : "";
      stateController.text = selectedSupplier.state.toString() != "null"
          ? selectedSupplier.state.toString()
          : "";
      countryController.text = selectedSupplier.country.toString() != "null"
          ? selectedSupplier.country.toString()
          : "";
      zipController.text = selectedSupplier.zip.toString() != "null"
          ? selectedSupplier.zip.toString()
          : "";
      postcodeController.text = selectedSupplier.postcode.toString() != "null"
          ? selectedSupplier.postcode.toString()
          : "";
      companyNameController.text =
          selectedSupplier.companyName.toString() != "null"
              ? selectedSupplier.companyName.toString()
              : "";
    }
  }

  SupplierDataModel getFieldData() {
    SupplierDataModel model = SupplierDataModel(
        name: nameController.text,
        address: addressController.text,
        city: cityController.text,
        companyName: companyNameController.text,
        country: countryController.text,
        email: emailController.text,
        mobile: mobileController.text,
        postcode: postcodeController.text,
        state: stateController.text,
        zip: zipController.text);
    return model;
  }

  String taxUpdateLoadingIndex = "-1";
  void changeStatus(String id, int index, bool value) async {
    taxUpdateLoadingIndex = id;
    update();

    ResponseModel responseModel = await supplierRepo.supplierStatusChangeData(
      id,
    );

    if (responseModel.statusCode == 200) {
      SupplierStatusChangeResponseModel model =
          supplierStatusChangeResponseModelFromJson(
              jsonEncode(responseModel.responseJson));

      if (model.status.toString().toLowerCase() == "success") {
        if (!value) {
          filteredSupplierData[index].status = "1";
        } else {
          filteredSupplierData[index].status = "0";
        }
        update();
        CustomSnackBar.success(successList: [model.message.toString()]);
      } else {
        CustomSnackBar.error(errorList: model.message ?? ["Request failed"]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    taxUpdateLoadingIndex = "-1";
    update();
  }

  void updateCoupon(String couponId) async {
    isSubmitting = true;
    SupplierDataModel model = getFieldData();
    update();

    ResponseModel responseModel =
        await supplierRepo.updateSupplier(model, couponId);

    if (responseModel.statusCode == 200) {
      CouponUpdateResponseModel model = couponUpdateResponseModelFromJson(
          jsonEncode(responseModel.responseJson));

      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        getSupplierData();
        Get.back();
        update();
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    isSubmitting = false;
    update();
  }
}
