import 'dart:convert';

import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/model/coupon/add_new_coupon_response_model.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/model/supplier/supplier_data.dart';
import 'package:ovosale/data/repo/supplier/new_supplier_repo.dart';
import 'package:ovosale/data/services/shared_pref_service.dart';

class NewSupplierController extends GetxController {
  NewSupplierRepo newSupplierRepo;
  NewSupplierController({required this.newSupplierRepo});
  String selectedValue = "%";
  String discountType = "1";

  final TextEditingController nameController = TextEditingController();
  final TextEditingController emailController = TextEditingController();
  final TextEditingController mobileController = TextEditingController();
  final TextEditingController addressController = TextEditingController();
  final TextEditingController cityController = TextEditingController();
  final TextEditingController stateController = TextEditingController();
  final TextEditingController countryController = TextEditingController();
  final TextEditingController zipController = TextEditingController();
  final TextEditingController postcodeController = TextEditingController();
  final TextEditingController companyNameController = TextEditingController();

  String defaultCurrency = "";
  List<Map<String, String>> dropdownData = [];

  getData() {
    defaultCurrency = SharedPreferenceService.getString(
      SharedPreferenceService.defaultCurrencyKey,
    );
    dropdownData = [
      {"label": "%"},
      {"label": defaultCurrency},
    ];
    update();
  }

  bool isSubmitting = false;

  SupplierDataModel getSupplierData() {
    SupplierDataModel model = SupplierDataModel(
      name: nameController.text,
      email: emailController.text,
      mobile: mobileController.text,
      address: addressController.text,
      city: cityController.text,
      companyName: companyNameController.text,
      country: countryController.text,
      postcode: postcodeController.text,
      state: stateController.text,
      zip: zipController.text,
    );
    return model;
  }

  void createSupplier() async {
    isSubmitting = true;
    SupplierDataModel model = getSupplierData();
    update();

    ResponseModel responseModel =
        await newSupplierRepo.createNewSupplierRepo(model);

    if (responseModel.statusCode == 200) {
      AddNewCouponResponseModel model = addNewCouponResponseModelFromJson(
          jsonEncode(responseModel.responseJson));

      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        Get.back();
        isSubmitting = false;
        update();
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    isSubmitting = false;
    update();
  }
}
