import 'dart:convert';
import 'package:ovosale/core/translations/localization_controller.dart';
import 'package:get/get.dart';
import 'package:ovosale/core/route/route.dart';
import 'package:ovosale/core/utils/messages.dart';
import 'package:ovosale/core/utils/my_strings.dart';
import 'package:ovosale/core/utils/util.dart';
import 'package:ovosale/data/model/general_setting/general_setting_response_model.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/repo/auth/general_setting_repo.dart';
import 'package:ovosale/data/services/shared_pref_service.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';

class SplashController extends GetxController {
  GeneralSettingRepo repo;

  SplashController({required this.repo});
  LocalizationController localizationController = LocalizationController();
  bool isLoading = true;
  gotoNextPage() async {
    bool isRemember =
        SharedPreferenceService.getBool(SharedPreferenceService.rememberMeKey);
    noInternet = false;
    update();

    await loadAndSaveGeneralSettingsData(isRemember);
    printW(noInternet);
    await loadLanguage();
  }

  bool noInternet = false;
  loadAndSaveGeneralSettingsData(bool isRemember) async {
    ResponseModel response = await repo.getGeneralSetting();
    printW(response.statusCode);
    if (response.statusCode == 200) {
      GeneralSettingResponseModel model =
          GeneralSettingResponseModel.fromJson(response.responseJson);
      if (model.status?.toLowerCase() == MyStrings.success) {
        await SharedPreferenceService.setGeneralSettingData(model);
        await SharedPreferenceService.setString(
            SharedPreferenceService.defaultCurrencyKey,
            model.data?.generalSetting?.curText ?? "");
        await SharedPreferenceService.setString(
            SharedPreferenceService.defaultCurrencySymbolKey,
            model.data?.generalSetting?.curSym ?? "");
      } else {
        List<String> message = [MyStrings.somethingWentWrong];
        CustomSnackBar.error(errorList: model.message ?? message);
      }
    } else {
      if (response.statusCode == 503) {
        noInternet = true;
        update();
      }
      // CustomSnackBar.error(errorList: [response.message]);
    }

    isLoading = false;
    update();

    if (noInternet) {
      return;
    }

    if (isRemember) {
      Future.delayed(const Duration(seconds: 1), () {
        Get.offAndToNamed(RouteHelper.bottomNavBar);
      });
    } else {
      Future.delayed(const Duration(seconds: 1), () {
        Get.offAndToNamed(RouteHelper.loginScreen);
      });
    }
  }

  Future<void> loadLanguage() async {
    localizationController.loadCurrentLanguage();
    String languageCode = localizationController.locale.languageCode;

    ResponseModel response = await repo.getLanguage(languageCode);
    if (response.statusCode == 200) {
      try {
        Map<String, Map<String, String>> language = {};

        saveLanguageList(jsonEncode(response.responseJson));
        var resJson = (response.responseJson);
        Map value = resJson['data']['file'].toString() == '[]'
            ? {}
            : resJson['data']['file'];
        Map<String, String> json = {};
        value.forEach((key, value) {
          json[key] = value.toString();
        });
        language[
                '${localizationController.locale.languageCode}_${localizationController.locale.countryCode}'] =
            json;
        Get.addTranslations(Messages(languages: language).keys);
      } catch (e) {
        CustomSnackBar.error(errorList: [e.toString()]);
      }
    } else {
      CustomSnackBar.error(errorList: [response.message]);
    }
  }

  void saveLanguageList(String languageJson) async {
    await SharedPreferenceService.setString(
        SharedPreferenceService.languageListKey, languageJson);
    return;
  }
}
