import 'package:flutter/cupertino.dart';
import 'package:get/get.dart';
import 'package:ovosale/data/controller/cart/global_controller.dart';
import 'package:ovosale/data/model/sale_list/sale_list_response_model.dart';
import 'package:ovosale/data/repo/sale_list/sale_list_repo.dart';

import '../../../app/components/snack_bar/show_custom_snackbar.dart';
import '../../../core/utils/my_strings.dart';
import '../../model/global/response_model/response_model.dart';

class SaleListController extends GetxController {
  SaleListRepo saleListRepo;
  SaleListController({required this.saleListRepo});

  TextEditingController searchController = TextEditingController();
  List<SalesList> saleList = [];

  int page = 0;
  String? nextPageUrl;
  bool isLoading = true;

  GlobalController globalController = Get.find();

  Future<void> getSalesListData({bool isPagination = false}) async {
    if (isPagination == false) {
      page = 0;
      isLoading = true;
      update();
    }

    page = page + 1;

    if (page == 1) {
      saleList.clear();
    }

    String pram = "?page=$page&search=${searchController.text}";

    ResponseModel responseModel = await saleListRepo.getSaleList(pram: pram);

    if (responseModel.statusCode == 200) {
      SaleListResponseModel model =
          SaleListResponseModel.fromJson(responseModel.responseJson);

      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        nextPageUrl = model.data?.sales?.nextPageUrl;
        saleList.addAll(model.data?.sales?.data ?? []);
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }

    isLoading = false;
    update();
  }

  bool hasNext() {
    return nextPageUrl != null &&
            nextPageUrl!.isNotEmpty &&
            nextPageUrl != 'null'
        ? true
        : false;
  }

  void onSearch() async {
    await getSalesListData();
  }

  String selectedAction = MyStrings.action;
  List<String> actionTypeList = [
    MyStrings.action,
    MyStrings.editSale,
    MyStrings.viewInvoice,
    MyStrings.downloadInvoice
  ];
}
