import 'dart:convert';

import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/core/utils/my_strings.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/model/payment_method/payment_method_status_response_model.dart';
import 'package:ovosale/data/model/role_and_permission/role_and_permission_response_model.dart';
import 'package:ovosale/data/repo/role_and_permission/role_and_permission_repo.dart';

import '../../model/profile/profile_response_model.dart';

class RoleAndPermissionController extends GetxController {
  RoleandPermissionRepo roleandPermissionRepo;
  ProfileResponseModel model = ProfileResponseModel();

  RoleAndPermissionController({required this.roleandPermissionRepo});

  TextEditingController methodNameController = TextEditingController();

  List<Role> rolesData = [];
  List<Role> filteredRole = [];
  bool isLoading = false;

  String searchQuery = '';

  void getRoleandPermissionData() async {
    rolesData = [];
    isLoading = true;
    update();
    ResponseModel responseModel =
        await roleandPermissionRepo.getRoleAndPermissionData();
    if (responseModel.statusCode == 200) {
      RoleandPermissionResponseModel model =
          RoleandPermissionResponseModel.fromJson(responseModel.responseJson);
      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        rolesData.addAll(model.data?.roles ?? []);
        filterRoleAndPermission("");
        isLoading = false;
        update();
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    isLoading = false;
    update();
  }

  void filterRoleAndPermission(String query) {
    if (query.isEmpty) {
      filteredRole = List.from(rolesData);
    } else {
      filteredRole = rolesData
          .where((category) =>
              category.name!.toLowerCase().contains(query.toLowerCase()))
          .toList();
    }
    update();
  }

  bool submitLoading = false;

  String taxUpdateLoadingIndex = "-1";
  void changeStatus(String id, int index, bool value) async {
    taxUpdateLoadingIndex = id;
    update();

    ResponseModel responseModel =
        await roleandPermissionRepo.roleStatusChangeData(id);

    if (responseModel.statusCode == 200) {
      PaymentMethodStatusResponseModel model =
          paymentMethodStatusResponseModelFromJson(
              jsonEncode(responseModel.responseJson));

      if (model.status.toString().toLowerCase() == "success") {
        if (!value) {
          filteredRole[index].status = "1";
        } else {
          filteredRole[index].status = "0";
        }
        CustomSnackBar.success(successList: [model.message.toString()]);
      } else {
        CustomSnackBar.error(errorList: model.message ?? ["Request failed"]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }

    taxUpdateLoadingIndex = "-1";
    update();
  }

  void updateMethod(
    String id,
  ) async {
    submitLoading = true;
    update();
    ResponseModel responseModel =
        await roleandPermissionRepo.updatePaymentMethodData(
      id,
      methodNameController.text,
    );

    if (responseModel.statusCode == 200) {
      PaymentMethodStatusResponseModel model =
          paymentMethodStatusResponseModelFromJson(
              jsonEncode(responseModel.responseJson));

      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        getRoleandPermissionData();
        Get.back();
        isLoading = false;
        update();
        CustomSnackBar.success(
            successList: model.message ?? [MyStrings.success]);
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    submitLoading = false;
    update();
  }
}
