import 'dart:convert';

import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/core/utils/my_strings.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/model/payment_method/payment_method_status_response_model.dart';
import 'package:ovosale/data/model/role_and_permission/new_role_and_permission_model.dart';
import 'package:ovosale/data/model/role_and_permission/role_and_permission_response_model.dart';
import 'package:ovosale/data/model/role_and_permission/role_and_permission_uuupdate_response_model.dart'
    as prefix;
import 'package:ovosale/data/repo/role_and_permission/new_role_and_permission_repo.dart';

import '../../model/profile/profile_response_model.dart';

class NewRoleAndPermissionController extends GetxController {
  NewRoleandPermissionRepo newRoleandPermissionRepo;
  ProfileResponseModel model = ProfileResponseModel();

  NewRoleAndPermissionController({required this.newRoleandPermissionRepo});

  TextEditingController methodNameController = TextEditingController();

  List<Permission> permissions = [];
  Role? role;
  bool isLoading = false;

  String searchQuery = '';

  Role roleId = Role(id: "-1");

  Map<String, List<Permission>> groupedPermissions = {};
  List<String> groupNames = [];

  List<String> activePermissionIds = [];
  List<String> newlyAddedPermissionIds = [];

  void getNewRoleandPermissionData() async {
    permissions = [];
    groupedPermissions.clear();
    groupNames.clear();
    activePermissionIds.clear();
    isLoading = true;
    update();

    ResponseModel responseModel = await newRoleandPermissionRepo
        .getRoleAndPermissionData(roleId.id ?? "-1");

    if (responseModel.statusCode == 200) {
      NewRoleandPermissionResponseModel model =
          NewRoleandPermissionResponseModel.fromJson(
              responseModel.responseJson);

      if (model.status.toString() == MyStrings.success.toLowerCase()) {
        permissions.addAll(model.data?.permissions ?? []);
        role = model.data?.role;

        activePermissionIds =
            role?.permissions?.map((e) => e.id ?? "").toList() ?? [];

        for (var permission in permissions) {
          if (permission.groupName != null) {
            groupedPermissions.putIfAbsent(permission.groupName!, () => []);
            groupedPermissions[permission.groupName!]!.add(permission);
          }
        }

        groupNames = groupedPermissions.keys.toList();

        for (var i = 0; i < groupNames.length; i++) {
          if (isGroupSwitchOn(i) == false) {
            selectAll = false;
            break;
          }
        }

        isLoading = false;
        update();
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }

    isLoading = false;
    update();
  }

  int expandedGroupIndex = 0;

  void toggleGroup(int index) {
    if (expandedGroupIndex == index) {
      expandedGroupIndex = -1;
    } else {
      expandedGroupIndex = index;
    }
    update();
  }

  bool selectAll = true;
  void selectAllItems() {
    selectAll = !selectAll;
    toggleAllGroupsSelection(selectAll);
    update();
  }

  Map<int, bool> groupSwitchStates = {};

  bool isGroupSwitchOn(int groupIndex) {
    String groupName = groupNames[groupIndex];
    List<Permission> groupPermissions = groupedPermissions[groupName] ?? [];

    bool isOn = groupPermissions.isNotEmpty &&
        groupPermissions.every(
          (permission) => activePermissionIds.contains(permission.id ?? ""),
        );

    groupSwitchStates[groupIndex] = isOn;

    return isOn;
  }

  void toggleGroupSwitch(int groupIndex) {
    bool newState = !(groupSwitchStates[groupIndex] ?? false);

    groupSwitchStates[groupIndex] = newState;
    update();

    toggleGroupPermissions(groupIndex, newState);
  }

  void toggleGroupPermissions(int groupIndex, bool value) {
    String groupName = groupNames[groupIndex];
    List<Permission> groupPermissions = groupedPermissions[groupName] ?? [];

    if (value) {
      for (var permission in groupPermissions) {
        if (!activePermissionIds.contains(permission.id ?? "")) {
          activePermissionIds.add(permission.id ?? "");
        }
      }
    } else {
      for (var permission in groupPermissions) {
        activePermissionIds.remove(permission.id ?? "");
      }
    }

    groupSwitchStates[groupIndex] = value;

    update();
  }

  void toggleAllGroupsSelection(bool selectAll) {
    for (int i = 0; i < groupNames.length; i++) {
      groupSwitchStates[i] = selectAll;
      toggleGroupPermissions(i, selectAll);
    }

    update();
  }

  addPermissionCheckbox(String id) {
    if (activePermissionIds.contains(id)) {
      activePermissionIds.remove(id);
    } else {
      activePermissionIds.add(id);
    }
    update();
  }

  bool submitLoading = false;
  void changeStatus(String id, String name) async {
    submitLoading = true;
    update();

    update();

    ResponseModel responseModel =
        await newRoleandPermissionRepo.roleStatusChangeData(id, name);

    if (responseModel.statusCode == 200) {
      PaymentMethodStatusResponseModel model =
          paymentMethodStatusResponseModelFromJson(
              jsonEncode(responseModel.responseJson));

      if (model.status.toString().toLowerCase() == "success") {
        getNewRoleandPermissionData();
        CustomSnackBar.success(successList: [model.message.toString()]);
      } else {
        CustomSnackBar.error(errorList: model.message ?? ["Request failed"]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }

    submitLoading = false;
    update();
  }

  void updatePermission() async {
    submitLoading = true;
    update();

    Map<String, dynamic> body = {};
    int i = 0;
    for (var v in activePermissionIds) {
      body.addAll({
        'permissions[$i]': v,
      });
      i++;
    }

    ResponseModel responseModel =
        await newRoleandPermissionRepo.updateRoleandPermissionRepo(
      roleId.id ?? "-1",
      body,
    );

    if (responseModel.statusCode == 200) {
      prefix.RoleandPermissionUpdateResponseModel model =
          prefix.roleandPermissionUpdateResponseModelFromJson(
              jsonEncode(responseModel.responseJson));

      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        getNewRoleandPermissionData();
        Get.back();
        isLoading = false;
        update();
        CustomSnackBar.success(
            successList: model.message ?? [MyStrings.success]);
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    submitLoading = false;
    update();
  }
}
