import 'package:flutter/cupertino.dart';
import 'package:get/get.dart';
import 'package:ovosale/core/helper/string_format_helper.dart';
import 'package:ovosale/data/controller/cart/global_controller.dart';
import 'package:ovosale/data/model/report/expense_report_response_model.dart';
import 'package:ovosale/data/model/report/profilt_loss_report_response_model.dart';
import 'package:ovosale/data/model/report/purchase_report_response_model.dart';
import 'package:ovosale/data/model/report/sales_report_response_model.dart';
import 'package:ovosale/data/repo/report_repo/report_repo.dart';

import '../../../app/components/snack_bar/show_custom_snackbar.dart';
import '../../../core/utils/my_strings.dart';
import '../../model/global/response_model/response_model.dart';
import '../../model/new_sale/required_data_response_model.dart';
import '../../model/report/stock_report_response_model.dart';

class ReportController extends GetxController {
  ReportRepo reportRepo;
  ReportController({required this.reportRepo});

  GlobalController globalCartCountController = Get.find();

  TextEditingController searchController = TextEditingController();

  int selectedTab = 0;

  List<Stock> stockList = [];
  List<SalesReport> salesReportList = [];
  List<Purchase> purchaseReportList = [];
  List<Expense> expenseReportList = [];
  List<ProfitLoss> profitLossReportList = [];

  int page = 0;
  String? nextPageUrl;

  bool isLoading = true;

  Future<void> getStockData({bool isPagination = false}) async {
    if (isPagination == false) {
      page = 0;
      isLoading = true;
      update();
    }

    page = page + 1;

    if (page == 1) {
      stockList.clear();
    }

    String pram = "";

    pram +=
        "?warehouse_id=${globalCartCountController.selectedWareHouse.id}&page=$page&search=${searchController.text}";

    ResponseModel responseModel = await reportRepo.getStockReport(pram: pram);

    if (responseModel.statusCode == 200) {
      StockReportResponseModel model =
          StockReportResponseModel.fromJson(responseModel.responseJson);

      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        nextPageUrl = model.data?.products?.nextPageUrl;
        stockList.addAll(model.data?.products?.data ?? []);
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }

    isLoading = false;
    update();
  }

  Future<void> getSalesReportData({bool isPagination = false}) async {
    if (isPagination == false) {
      page = 0;
      isLoading = true;
      update();
    }

    page = page + 1;

    if (page == 1) {
      salesReportList.clear();
    }

    String pram = "?page=$page&search=${searchController.text}";

    ResponseModel responseModel = await reportRepo.getSalesReport(pram: pram);

    if (responseModel.statusCode == 200) {
      SalesReportResponseModel model =
          SalesReportResponseModel.fromJson(responseModel.responseJson);

      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        nextPageUrl = model.data?.sales?.nextPageUrl;
        salesReportList.addAll(model.data?.sales?.data ?? []);
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }

    isLoading = false;
    update();
  }

  Future<void> getPurchaseReportData({bool isPagination = false}) async {
    if (isPagination == false) {
      page = 0;
      isLoading = true;
      update();
    }

    page = page + 1;

    if (page == 1) {
      purchaseReportList.clear();
    }

    String pram = "?page=$page&search=${searchController.text}";

    ResponseModel responseModel =
        await reportRepo.getPurchaseReport(pram: pram);

    if (responseModel.statusCode == 200) {
      PurchaseReportResponseModel model =
          PurchaseReportResponseModel.fromJson(responseModel.responseJson);

      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        nextPageUrl = model.data?.purchases?.nextPageUrl;
        purchaseReportList.addAll(model.data?.purchases?.data ?? []);
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }

    isLoading = false;
    update();
  }

  Future<void> getExpenseReportData({bool isPagination = false}) async {
    if (isPagination == false) {
      page = 0;
      isLoading = true;
      update();
    }

    page = page + 1;

    if (page == 1) {
      expenseReportList.clear();
    }

    String pram = "?page=$page&search=${searchController.text}";

    ResponseModel responseModel = await reportRepo.getExpenseReport(pram: pram);

    if (responseModel.statusCode == 200) {
      ExpenseReportResponseModel model =
          ExpenseReportResponseModel.fromJson(responseModel.responseJson);

      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        nextPageUrl = model.data?.expenses?.nextPageUrl;
        expenseReportList.addAll(model.data?.expenses?.data ?? []);
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }

    isLoading = false;
    update();
  }

  Future<void> getLossProfitReportData({bool isPagination = false}) async {
    if (isPagination == false) {
      page = 0;
      isLoading = true;
      update();
    }

    page = page + 1;

    if (page == 1) {
      profitLossReportList.clear();
    }

    String pram = "?page=$page&search=${searchController.text}";

    ResponseModel responseModel =
        await reportRepo.getProfitLossReport(pram: pram);

    if (responseModel.statusCode == 200) {
      ProfitLossReportResponseModel model =
          ProfitLossReportResponseModel.fromJson(responseModel.responseJson);

      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        nextPageUrl = model.data?.invoicesWise?.nextPageUrl;
        profitLossReportList.addAll(model.data?.invoicesWise?.data ?? []);
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }

    isLoading = false;
    update();
  }

  bool hasNext() {
    return nextPageUrl != null &&
            nextPageUrl!.isNotEmpty &&
            nextPageUrl != 'null'
        ? true
        : false;
  }

  void changeTab() {
    searchController.clear();
  }

  changeSelectedWareHouse(Warehouse warehouse) async {
    Get.back();
    globalCartCountController.selectedWareHouse = warehouse;
    await getStockData();
  }

  void onSearch(int currentTab, isClearController) async {
    if (isClearController) {
      searchController.clear();
    }

    if (currentTab == 0) {
      await getStockData();
    } else if (currentTab == 1) {
      await getSalesReportData();
    } else if (currentTab == 2) {
      await getPurchaseReportData();
    } else if (currentTab == 3) {
      await getExpenseReportData();
    } else if (currentTab == 4) {
      await getLossProfitReportData();
    }
  }

  String calculateProfitOrLoss(
      {required String amount, required purchaseValue}) {
    double totalAmount = AppConverter.toDouble(amount);
    double purchaseAmount = AppConverter.toDouble(purchaseValue);

    return AppConverter.formatNumber("${totalAmount - purchaseAmount}");
  }
}
