import 'package:get/get.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/cart/global_controller.dart';
import 'package:ovosale/data/model/new_sale/new_sale_response_model.dart';

import '../../repo/qr_code/qr_code_repo.dart';

class QrCodeController extends GetxController {
  QrCodeRepo qrCodeRepo;
  QrCodeController({required this.qrCodeRepo});

  String? qrCode;

  bool isLoading = false;

  bool isScannerLoading = false;
  submitBarCodeData(String scannedData) async {
    isLoading = true;
    update();
    GlobalController globalCartCountController = Get.find();
    await globalCartCountController
        .addToCart(SaleProduct(sku: scannedData), showSnackBar: true)
        .then((value) {
      isLoading = false;
      Get.back();
    });
    printX("scanned data: $scannedData");
  }

  void setQrCodeNull() {
    qrCode = null;
    update();
  }
}
