import 'dart:convert';

import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/core/utils/my_strings.dart';
import 'package:ovosale/core/utils/url_container.dart';
import 'package:ovosale/core/utils/util.dart';
import 'package:ovosale/data/controller/cart/global_controller.dart';
import 'package:ovosale/data/controller/file_download/file_downloader.dart';
import 'package:ovosale/data/model/auth/two_factor/two_factor_data_model.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/model/purchase/purchase_attchment_response_model.dart';
import 'package:ovosale/data/model/purchase/purchase_data_response_model.dart';
import 'package:ovosale/data/repo/purchase/purchase_repo.dart';

class PurchaseController extends GetxController {
  PurchaseRepo purchaseRepo;
  PurchaseController({required this.purchaseRepo});

  final int step = 0;

  GlobalController globalController = Get.find();

  List<PurchaseData> purchaseData = [];
  List<PurchaseData> filteredPurchaseData = [];
  TextEditingController searchPurchaseController = TextEditingController();
  String nextPageUrl = "";
  int currentPage = 1;

  bool isLoading = false;
  TwoFactorCodeModel twoFactorCodeModel = TwoFactorCodeModel();

  void getPurchaseData({bool isPagination = false}) async {
    if (isPagination == false) {
      currentPage = 0;
      isLoading = true;
      update();
    }

    currentPage = currentPage + 1;

    if (currentPage == 1) {
      filteredPurchaseData.clear();
    }

    String pram = "";

    pram += "?page=$currentPage";
    pram += "&search=${searchPurchaseController.text}";

    update();
    ResponseModel responseModel = await purchaseRepo.purchaseRepo(pram);
    if (responseModel.statusCode == 200) {
      PurchaseDataResponseModel model = purchaseDataResponseModelFromJson(
          jsonEncode(responseModel.responseJson));
      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        filteredPurchaseData.addAll(model.data?.purchases?.data ?? []);
        nextPageUrl = model.data?.purchases?.nextPageUrl ?? "";
        isLoading = false;
        update();
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    isLoading = false;
    update();
  }

  bool isPdfDownloadLoading = false;
  String pdfLoadingIndex = "-1";
  pdfDownload(String id) async {
    pdfLoadingIndex = id;
    update();

    String url =
        "${UrlContainer.baseUrl}${UrlContainer.downloadPurchasePdfEndPoint}/$id";

    AnyFileDownloaderAndOpener pdfDownloader = AnyFileDownloaderAndOpener();
    try {
      await pdfDownloader.downloadAnyFile(url: url).then((value) {});
    } catch (e) {
      printE(e);
    }
    pdfLoadingIndex = "-1";
    update();
  }

  bool hasNext() {
    return nextPageUrl.isNotEmpty && nextPageUrl != 'null' ? true : false;
  }

  String url = "";
  String fileDownloadLoadingIndex = "-1";
  void getPurchaseAttachmentData(String purchaseId) async {
    fileDownloadLoadingIndex = purchaseId;
    update();
    try {
      ResponseModel responseModel = await purchaseRepo.attachment(purchaseId);
      if (responseModel.statusCode == 200) {
        PurchaseAttachmentResponseModel model =
            purchaseAttachmentResponseModelFromJson(
                jsonEncode(responseModel.responseJson));
        if (model.status.toString() ==
            MyStrings.success.toString().toLowerCase()) {
          url = model.data?.url.toString() ?? "";
          if (url.isNotEmpty) {
            AnyFileDownloaderAndOpener pdfDownloader =
                AnyFileDownloaderAndOpener();
            try {
              await pdfDownloader
                  .downloadAnyFile(url: url, isView: true)
                  .then((value) {});
            } catch (e) {
              printE(e);
            }
          }
          fileDownloadLoadingIndex = "-1";
          update();
        } else {
          CustomSnackBar.error(
              errorList: model.message ?? [MyStrings.requestFail.toString()]);
        }
      } else {
        CustomSnackBar.error(errorList: [responseModel.message.tr]);
      }
    } catch (e) {
      printE(e);
      fileDownloadLoadingIndex = "-1";
      update();
    }
    fileDownloadLoadingIndex = "-1";
    update();
  }

  bool isImage(String path) {
    if (path.contains('.jpg')) {
      return true;
    }
    if (path.contains('.png')) {
      return true;
    }
    if (path.contains('.jpeg')) {
      return true;
    }
    return false;
  }

  bool isPdf(String path) {
    if (path.contains('.pdf')) {
      return true;
    }
    if (path.contains('.PDF')) {
      return true;
    }
    return false;
  }

  bool isXlsx(String path) {
    if (path.contains('.xlsx')) {
      return true;
    }
    if (path.contains('.xls')) {
      return true;
    }
    if (path.contains('.xlx')) {
      return true;
    }
    return false;
  }

  bool isDoc(String path) {
    if (path.contains('.doc')) {
      return true;
    }
    if (path.contains('.docs')) {
      return true;
    }
    return false;
  }
}
