import 'dart:convert';
import 'dart:io';

import 'package:file_picker/file_picker.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/core/helper/date_converter.dart';
import 'package:ovosale/core/helper/string_format_helper.dart';
import 'package:ovosale/core/utils/my_strings.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/model/payment_method/payment_account_resonse_model.dart';
import 'package:ovosale/data/model/product/product_search_data_response_model.dart';
import 'package:ovosale/data/model/purchase/new_purchase_response_model.dart';
import 'package:ovosale/data/model/purchase/submit_purchase_response_model.dart';
import 'package:ovosale/data/repo/purchase/new_purchase_repo.dart';
import 'package:ovosale/data/services/shared_pref_service.dart';

class NewPurchaseController extends GetxController {
  NewPurchaseRepo newPurchaseRepo;
  NewPurchaseController({required this.newPurchaseRepo});

  TextEditingController referenceController = TextEditingController();
  TextEditingController dateController = TextEditingController();
  TextEditingController paidDateController = TextEditingController();
  TextEditingController paymentNoteController = TextEditingController();
  TextEditingController purchaseDiscountController = TextEditingController();
  TextEditingController shippingAmountController = TextEditingController();
  TextEditingController supplierPaidAmountController = TextEditingController();

  int step = 0;
  double subTotal = 0.00;
  double total = 0.00;

  String defaultCurrency = "";
  String supplierId = "";
  String warehouseId = "";

  List<Warehouse> warehouses = [];
  List<PaymentMethod> taxes = [];
  List<PaymentMethod> paymentMethods = [];
  List<Supplier> suppliers = [];
  List<String>? selectedVariantIds = [];
  List<String>? selectedDisabledVariantIds = [];
  List<PaymentMethod> paymentMethodList = [];
  Original? original;

  List<ProductElement> productsData = [];
  List<NewPurchaseFormModel> formData = [];
  PaymentAccountModel selectedPaymentAccount = PaymentAccountModel();

  String selectedTaxType = "Exclusive";
  String selectedTaxId = "";
  String selectedDiscountType = "Percent";
  String selectedPurchaseDiscountType = "Percent";
  PaymentMethod selectedPaymentMethod = PaymentMethod();
  bool discountInPercent = false;

  List<Map<String, String>> statusData = [
    {"label": "Received"},
    {"label": "Pending"},
    {"label": "Ordered"},
  ];
  List<Map<String, String>> taxTypeData = [
    {"name": "Exclusive"},
    {"name": "Inclusive"},
  ];

  List<Map<String, String>> discountTypeData = [
    {"name": "Percent"},
    {"name": "Fixed"},
  ];

  @override
  void onInit() {
    super.onInit();
    dateController.text = DateConverter.formatDepositTimeWithAmFormat(
      DateTime.now().toString(),
    );
    paidDateController.text = DateConverter.formatDepositTimeWithAmFormat(
      DateTime.now().toString(),
    );
  }

  File? selectedFile;

  String selectedSupplier = "Select Supplier";
  String selectedStatus = "Received";
  String selectedWarehouse = "Select Warehouse";
  List<ProductElement> selectedProduct = [];

  bool isLoading = false;

  void pickFile() async {
    FilePickerResult? result = await FilePicker.platform.pickFiles(
      allowMultiple: false,
      type: FileType.custom,
      allowedExtensions: ['jpg', 'png', 'jpeg'],
    );

    if (result == null) return;

    selectedFile = File(result.files.single.path!);
    update();
  }

  void removeSelectedFile() {
    selectedFile = null;
    update();
  }

  String paymentMethodId = "";

  updateSelectedProduct(ProductElement? variants,
      {bool isSelected = false, String? subTitleVariantText}) {
    if (isSelected) {
      // Deselecting the product
      selectedVariantIds?.remove(variants?.id ?? "0");
      selectedProduct.removeWhere((v) {
        return v.id == variants?.id;
      });
      formData.removeWhere((item) {
        return item.productName == variants?.name;
      });
    } else {
      selectedVariantIds?.add(variants?.id ?? "0");
      selectedProduct.add(variants!);

      String? selectedTaxType = taxes.isNotEmpty
          ? taxes
                  .firstWhereOrNull(
                    (tax) => tax.id == variants.original?.taxId.toString(),
                  )
                  ?.name ??
              taxes.first.name
          : null;

      formData.add(
        NewPurchaseFormModel(
          productId: variants.original?.productId,
          variantId: variants.original?.variantId,
          vatPercentage: variants.original?.taxPercentage ?? "0",
          productName: variants.name ?? "Unknown Product",
          quantityController: TextEditingController(text: "1"),
          // taxType: taxTypeData.first["name"],
          taxType:
              variants.original?.taxType == "1" ? "Exclusive" : "Inclusive",
          selectedTax: selectedTaxType,
          taxId: variants.original?.taxId,
          profitMarginController: TextEditingController(
              text: AppConverter.formatNumber(
                  variants.original?.profitMargin ?? "")),
          salePriceController: TextEditingController(
              text: AppConverter.formatNumber(
                  variants.original?.salePrice ?? "")),
          basePriceController: TextEditingController(
              text: AppConverter.formatNumber(
                  variants.original?.basePrice ?? "")),
          purchasePriceController: TextEditingController(
              text: AppConverter.formatNumber(
                  variants.original?.purchasePrice.toString() ?? "",
                  precision: 2)),
          discountType:
              variants.original?.discountType == "1" ? "Percent" : "Fixed",
          saleDiscountController: TextEditingController(
              text: AppConverter.formatNumber(
                  variants.original?.discountType == "1"
                      ? variants.original?.discountValue ?? "0"
                      : variants.original?.discountAmount ?? "0")),
          subTitleVariantText: subTitleVariantText,
        ),
      );
      calculateUpdateSalePrice(formData.length - 1);
    }

    update(); // Notify listeners or update the UI
  }

  void getNewPurchaseData() async {
    paymentMethodList = [];
    isLoading = true;
    update();
    ResponseModel responseModel = await newPurchaseRepo.newPurchaseRepo();
    if (responseModel.statusCode == 200) {
      NewPurchaseDataResponseModel model = newPurchaseDataResponseModelFromJson(
          jsonEncode(responseModel.responseJson));
      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        await initializeDefaultOptions();
        suppliers.addAll(model.data?.suppliers ?? []);
        warehouses.addAll(model.data?.warehouses ?? []);
        taxes.addAll(model.data?.taxes ?? []);
        paymentMethods.addAll(model.data?.paymentMethods ?? []);
        paymentMethodList = model.data?.paymentMethods ?? [];
        defaultCurrency = SharedPreferenceService.getString(
          SharedPreferenceService.defaultCurrencyKey,
        );
        getProductData();

        isLoading = false;
        update();
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    isLoading = false;
    update();
  }

  TextEditingController productSearchController = TextEditingController();

  void getProductData() async {
    update();

    ResponseModel responseModel =
        await newPurchaseRepo.getProductsData(productSearchController.text);
    if (responseModel.statusCode == 200) {
      ProductSearchDataResponseModel model =
          productSearchDataResponseModelFromJson(
              jsonEncode(responseModel.responseJson));
      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        productsData = model.data?.products ?? [];

        isLoading = false;
        update();
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    update();
  }

  bool submitLoading = false;

  void submitProductData() async {
    submitLoading = true;
    update();

    Map<String, dynamic> body = {
      'purchase_date': dateController.text,
      'supplier_id': supplierId,
      'warehouse_id': warehouseId,
      'reference_number': referenceController.text,
      'status': selectedStatus == "Received"
          ? 1
          : selectedStatus == "Pending"
              ? 2
              : 3,
      'discount_type': selectedPurchaseDiscountType == "Percent" ? 1 : 2,
      'discount': purchaseDiscountController.text,
      'shipping_amount': shippingAmountController.text,
      'paid_amount': supplierPaidAmountController.text,
      'paid_date': paidDateController.text,
      'payment_type': paymentMethodId,
      'payment_account': selectedPaymentAccount.id.toString(),
      'payment_note': paymentNoteController.text,
    };
    int i = 0;
    for (var v in formData) {
      body.addAll({
        'purchase_details[$i][product_details_id]': v.productId ?? "",
        'purchase_details[$i][qty]': v.quantityController?.text,
        'purchase_details[$i][base_price]': v.basePriceController?.text ?? "",
        'purchase_details[$i][tax_id]': v.taxId,
        'purchase_details[$i][purchase_price]': v.purchasePriceController?.text,
        'purchase_details[$i][tax_type]': v.taxType == "Exclusive" ? 1 : 2,
        'purchase_details[$i][purchase_price]': v.purchasePriceController?.text,
        'purchase_details[$i][sale_price]': v.salePriceController?.text,
        'purchase_details[$i][profit_margin]': v.profitMarginController?.text,
        'purchase_details[$i][discount_type]':
            v.discountType == "Percent" ? 1 : 2,
        'purchase_details[$i][discount]': v.saleDiscountController?.text ?? "",
      });

      i++;
    }
    update();
    ResponseModel responseModel =
        await newPurchaseRepo.createPurchase(body, selectedFile);

    if (responseModel.statusCode == 200) {
      SubmitNewPurchaseResponseModel model =
          submitNewPurchaseResponseModelFromJson(
              jsonEncode(responseModel.responseJson));

      if (model.status.toString().toLowerCase() == "success") {
        Get.back();
        CustomSnackBar.success(successList: [model.message.toString()]);
      } else {
        CustomSnackBar.error(errorList: model.message ?? ["Request failed"]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }

    submitLoading = false;
    update();
  }

  initializeDefaultOptions() async {
    suppliers.insert(0, Supplier(name: "Select Supplier"));
    paymentMethods.insert(0, PaymentMethod(name: "Select Payment Method"));
    taxes.insert(0, PaymentMethod(name: "Select Tax"));
    warehouses.insert(0, Warehouse(name: "Select Warehouse"));
    // productsData.add(ProductElement(name: "Select Products"));
  }

  void changeSelectedDateOnlyValue(BuildContext context) async {
    DateTime? pickedDate = await showDatePicker(
      context: context,
      initialDate: DateTime.now(),
      firstDate: DateTime(1950),
      lastDate: DateTime.now(),
    );
    if (pickedDate != null) {
      final DateTime selectedDateTime = DateTime(
        pickedDate.year,
        pickedDate.month,
        pickedDate.day,
      );

      var formatedDate = DateConverter.formatDepositTimeWithAmFormat(
          selectedDateTime.toString());
      dateController.text = formatedDate.toString();
      update();
    }
    update();
  }

  void changePaidDateValue(BuildContext context) async {
    DateTime? pickedDate = await showDatePicker(
      context: context,
      initialDate: DateTime.now(),
      firstDate: DateTime(2000),
      lastDate: DateTime(2101),
    );
    if (pickedDate != null) {
      final DateTime selectedDateTime = DateTime(
        pickedDate.year,
        pickedDate.month,
        pickedDate.day,
      );

      var formatedDate = DateConverter.formatDepositTimeWithAmFormat(
          selectedDateTime.toString());
      dateController.text = formatedDate.toString();
      update();
    }
    update();
  }

  List<PaymentAccountModel> paymentAccountsDataList = [];

  int paymentMethodCurrentIndex = -1;
  void changeSelectedPaymentMethod(int index) {
    paymentMethodCurrentIndex = index;
    selectedPaymentMethod = paymentMethodList[index];
    paymentMethodId = selectedPaymentMethod.id.toString();
    selectedPaymentAccount = PaymentAccountModel();
    paymentAccountsDataList.clear();
    paymentAccountsDataList.insert(
        0, PaymentAccountModel(id: null, accountName: MyStrings.selectOne.tr));
    paymentAccountsDataList.addAll(selectedPaymentMethod.paymentAccounts ?? []);
    update();
  }

  void setSelectedPaymentAccount(value) {
    selectedPaymentAccount = value;
    update();
  }

  double totalSubTotal = 0.0;

  void calculateUpdateSalePrice(int index, {bool isEditingSalePrice = false}) {
    final formDataItem = formData[index];

    double basePrice =
        double.tryParse(formDataItem.basePriceController?.text ?? '0') ?? 0.0;
    double profitMargin =
        double.tryParse(formDataItem.profitMarginController?.text ?? '0') ??
            0.0;
    double vatPercentage =
        double.tryParse(formDataItem.vatPercentage ?? '0') ?? 0.0;

    double salePrice =
        double.tryParse(formDataItem.salePriceController?.text ?? '0') ?? 0.0;
    double discountPrice =
        double.tryParse(formDataItem.saleDiscountController?.text ?? '0') ??
            0.0;
    double productQuantity =
        double.tryParse(formDataItem.quantityController?.text ?? '0') ?? 0.0;

    discountInPercent =
        (formDataItem.discountType ?? selectedDiscountType) == "Percent";

    if (isEditingSalePrice) {
      if (basePrice > 0) {
        double countedVat = (vatPercentage / 100) * basePrice;
        double pp = basePrice +
            (formDataItem.taxType?.toString() == 'Exclusive' ? countedVat : 0);
        double extValue = salePrice - pp;
        profitMargin = (extValue / pp) * 100;

        profitMargin = profitMargin.isFinite ? profitMargin : 0;

        formDataItem.purchasePriceController?.text = pp.toString();

        var subTotalCount = pp * productQuantity;
        formDataItem.subTotalController?.text = subTotalCount.toString();
        double finalPrice = salePrice -
            (discountInPercent
                ? salePrice * (discountPrice / 100)
                : discountPrice);

        formDataItem.finalSalePriceController?.text =
            finalPrice.toStringAsFixed(2);
        update();
      } else {
        profitMargin = 0;
      }

      formDataItem.profitMarginController?.text =
          profitMargin.toStringAsFixed(2);
      double finalPrice = salePrice -
          (discountInPercent
              ? salePrice * (discountPrice / 100)
              : discountPrice);

      formDataItem.finalSalePriceController?.text =
          finalPrice.toStringAsFixed(2);
    } else {
      salePrice = basePrice * (1 + profitMargin / 100);

      if (formDataItem.taxType?.toString() == 'Exclusive') {
        salePrice *= (1 + vatPercentage / 100);
      }

      salePrice = salePrice < 0 ? 0 : salePrice;
      double finalPrice = salePrice -
          (discountInPercent
              ? salePrice * (discountPrice / 100)
              : discountPrice);

      double countedVat = (vatPercentage / 100) * basePrice;

      double pp = basePrice +
          (formDataItem.taxType?.toString() == 'Exclusive' ? countedVat : 0);
      formDataItem.purchasePriceController?.text = pp.toString();
      formDataItem.salePriceController?.text = salePrice.toStringAsFixed(2);
      formDataItem.finalSalePriceController?.text =
          finalPrice.toStringAsFixed(2);

      var subTotalCount = pp * productQuantity;
      formDataItem.subTotalController?.text = subTotalCount.toString();

      formDataItem.finalSalePriceController?.text =
          finalPrice.toStringAsFixed(2);
    }
    calculateTotalSubTotal();
    update();
  }

  void calculateTotalSubTotal() {
    totalSubTotal = 0.0;
    for (var item in formData) {
      double subTotal =
          double.tryParse(item.subTotalController?.text ?? '0') ?? 0.0;
      totalSubTotal += subTotal;
    }
    update();
  }

  double discountAmount = 0.0;
  void calculateTotal() {
    double purchaseDiscount =
        double.tryParse(purchaseDiscountController.text) ?? 0.0;
    double shippingAmount =
        double.tryParse(shippingAmountController.text) ?? 0.0;
    discountInPercent =
        selectedPurchaseDiscountType == "Percent" ? true : false;

    total = totalSubTotal -
        (discountInPercent
            ? (totalSubTotal * (purchaseDiscount / 100))
            : purchaseDiscount);
    discountAmount = (discountInPercent
        ? (totalSubTotal * (purchaseDiscount / 100))
        : purchaseDiscount);
    total = total + shippingAmount;

    update();
  }

  void changeStep() {
    if (step == 0) {
      if (warehouseId != "") {
        step++;
      } else {
        CustomSnackBar.error(errorList: [MyStrings.selectWarehouse.tr]);
      }
    } else if (step == 1) {
      if (selectedProduct.isNotEmpty) {
        step++;
        calculateTotal();
      } else {
        CustomSnackBar.error(errorList: [MyStrings.selectProducts.tr]);
      }
    }

    update();
  }

  void previuousStep() {
    if (step == 1) {
      step--;
    } else if (step == 2) {
      step--;
    }
    update();
  }
}
