import 'dart:convert';
import 'dart:io';

import 'package:file_picker/file_picker.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/core/helper/date_converter.dart';
import 'package:ovosale/core/helper/string_format_helper.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/model/product/product_search_data_response_model.dart';
import 'package:ovosale/data/model/purchase/edit_purchase_data_response_model.dart';
import 'package:ovosale/data/model/purchase/new_purchase_response_model.dart'
    as prefix;
import 'package:ovosale/data/model/purchase/submit_purchase_response_model.dart';
import 'package:ovosale/data/repo/purchase/edit_purchase_repo.dart';
import 'package:ovosale/data/services/shared_pref_service.dart';

class EditPurchaseController extends GetxController {
  EditPurchaseRepo editPurchaseRepo;
  EditPurchaseController({required this.editPurchaseRepo});

  TextEditingController referenceController = TextEditingController();
  TextEditingController dateController = TextEditingController();
  TextEditingController paidDateController = TextEditingController();
  TextEditingController paymentNoteController = TextEditingController();
  TextEditingController purchaseDiscountController = TextEditingController();
  TextEditingController shippingAmountController = TextEditingController();
  TextEditingController supplierPaidAmountController = TextEditingController();

  int step = 0;
  double subTotal = 0.00;
  double total = 0.00;

  String defaultCurrency = "";
  String supplierId = "";
  String warehouseId = "";

  List<Warehouse> warehouses = [];
  List<PaymentMethod> taxes = [];
  List<PaymentMethod> paymentMethods = [];
  List<Supplier> suppliers = [];
  List<String>? selectedVariantIds = [];
  List<String>? selectedDisabledVariantIds = [];

  Original? original;
  Purchase? purchase;

  List<ProductElement> productsData = [];
  List<prefix.NewPurchaseFormModel> formData = [];
  String selectedTaxType = "Select Tax";
  String selectedTaxId = "";
  String selectedDiscountType = "Percent";
  String selectedPurchaseDiscountType = "Percent";
  String selectedPaymentMethod = "Select Payment Method";
  bool discountInPercent = false;

  List<Map<String, String>> statusData = [
    {"label": "Received"},
    {"label": "Pending"},
    {"label": "Ordered"},
  ];
  List<Map<String, String>> taxTypeData = [
    {"name": "Exclusive"},
    {"name": "Inclusive"},
  ];

  List<Map<String, String>> discountTypeData = [
    {"name": "Percent"},
    {"name": "Fixed"},
  ];

  @override
  void onInit() {
    super.onInit();
    dateController.text = DateConverter.formatDepositTimeWithAmFormat(
      DateTime.now().toString(),
    );
    paidDateController.text = DateConverter.formatDepositTimeWithAmFormat(
      DateTime.now().toString(),
    );
  }

  File? selectedFile;

  String selectedSupplier = "Select Supplier";
  String selectedStatus = "Received";
  String selectedStaticStatus = "Received";
  String selectedWarehouse = "Select Warehouse";
  List<ProductElement> selectedProduct = [];

  bool isLoading = false;

  void pickFile() async {
    FilePickerResult? result = await FilePicker.platform.pickFiles(
      allowMultiple: false,
      type: FileType.custom,
      allowedExtensions: ['jpg', 'png', 'jpeg'],
    );

    if (result == null) return;

    selectedFile = File(result.files.single.path!);
    update();
  }

  void removeSelectedFile() {
    selectedFile = null;
    update();
  }

  String paymentMethodId = "";

  String purcahseId = "";
  void getPurchaseData() async {
    isLoading = true;
    update();
    ResponseModel responseModel =
        await editPurchaseRepo.getPurchaseData(purcahseId);
    if (responseModel.statusCode == 200) {
      EditPurchaseResponseModel model = editPurchaseResponseModelFromJson(
          jsonEncode(responseModel.responseJson));
      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        suppliers.addAll(model.data?.suppliers ?? []);
        warehouses.addAll(model.data?.warehouses ?? []);
        taxes.addAll(model.data?.taxes ?? []);
        paymentMethods.addAll(model.data?.paymentMethods ?? []);
        purchase = model.data?.purchase;
        defaultCurrency = SharedPreferenceService.getString(
          SharedPreferenceService.defaultCurrencyKey,
        );

        getProductData();
        initializeDefaultOptions();
        loadData(model);

        isLoading = false;
        update();
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    isLoading = false;
    update();
  }

  loadData(EditPurchaseResponseModel model) {
    selectedDisabledVariantIds ??= [];
    selectedVariantIds = [];
    dateController.text = model.data?.purchase?.purchaseDate ?? "";
    warehouseId = model.data?.purchase?.warehouseId ?? "";
    supplierId = model.data?.purchase?.supplierId ?? "";

    selectedStaticStatus = model.data?.purchase?.status == "1"
        ? "Received"
        : model.data?.purchase?.status == "2"
            ? "Pending"
            : "Ordered";
    selectedStatus = selectedStaticStatus;
    selectedSupplier = suppliers
        .firstWhere(
          (tax) => tax.id == model.data?.purchase?.supplierId.toString(),
        )
        .name
        .toString();

    selectedWarehouse = warehouses
        .firstWhere(
          (tax) => tax.id == model.data?.purchase?.warehouseId.toString(),
        )
        .name
        .toString();

    referenceController.text =
        (model.data?.purchase?.referenceNumber.toString() != "null"
                ? model.data?.purchase?.referenceNumber.toString()
                : "") ??
            "";

    selectedPurchaseDiscountType =
        model.data?.purchase?.discountType == "1" ? "Percent" : "Fixed";
    purchaseDiscountController.text = AppConverter.formatNumber(
        model.data?.purchase?.discountType == "1"
            ? model.data?.purchase?.discountValue ?? "0"
            : model.data?.purchase?.discountAmount ?? "0");
    shippingAmountController.text =
        AppConverter.formatNumber(model.data?.purchase?.shippingAmount ?? "0");

    for (PurchaseDetail details in purchase?.purchaseDetails ?? []) {
      selectedVariantIds?.add(details.productDetail?.variantId ?? "");

      selectedTaxId = taxes
          .firstWhere(
            (tax) => tax.id == details.productDetail?.taxId.toString(),
          )
          .name
          .toString();

      selectedTaxType = taxes
          .firstWhere(
            (tax) => tax.id == details.taxId.toString(),
          )
          .name
          .toString();

      formData.add(
        prefix.NewPurchaseFormModel(
          removable: false,
          purchaseDetailsId: details.id,
          productId: details.product?.id,
          vatPercentage: details.taxPercentage,
          productDetailId: details.productDetailsId.toString(),
          taxType: details.taxType == "1" ? "Exclusive" : "Inclusive",
          selectedTax: selectedTaxType,
          taxId: details.taxId,
          discountType: details.discountType == "1" ? "Percent" : "Fixed",
          productName: details.product?.name ?? "Unknown Product",
          quantityController: TextEditingController(text: details.quantity),
          profitMarginController: TextEditingController(
              text: AppConverter.formatNumber(
                  details.productDetail?.profitMargin ?? "")),
          salePriceController: TextEditingController(
              text: AppConverter.formatNumber(
                  details.productDetail?.salePrice ?? "")),
          basePriceController: TextEditingController(
              text: AppConverter.formatNumber(
                  details.productDetail?.basePrice ?? "")),
          saleDiscountController: TextEditingController(
              text: AppConverter.formatNumber(details.discountType == "1"
                  ? details.discountValue ?? "0"
                  : details.discountAmount ?? "0")),
          finalPriceController: TextEditingController(
              text: AppConverter.formatNumber(
                  details.productDetail?.finalPrice ?? "")),
          subTotalController: TextEditingController(
              text: AppConverter.formatNumber(totalSubTotal.toString())),
          purchasePriceController: TextEditingController(
            text: AppConverter.formatNumber(
                details.purchasePrice.toString(),
                precision: 2),
          ),
          subTitleVariantText:
              "${details.productDetail?.attribute != null ? details.productDetail?.attribute?.name : ""}${details.productDetail?.variant != null ? "-" : ""}${details.productDetail?.variant != null ? details.productDetail?.variant?.name : ""}",
          variantId: details.productDetail?.variantId,
        ),
      );
    }

    for (int i = 0; i < formData.length; i++) {
      printE("Loading form data $i");
      calculateUpdateSalePrice(i);
    }
  }

  updateSelectedProduct(ProductElement? variants,
      {required int index,
      bool isSelected = false,
      String? subTitleVariantText}) {
    if (isSelected) {
      if (formData[index].removable) {
        formData.removeAt(index);
      }

      update();
    } else {
      selectedVariantIds?.add(variants?.id ?? "0");
      selectedProduct.add(variants!);
      String? selectedTaxType = taxes.isNotEmpty
          ? taxes
                  .firstWhereOrNull(
                    (tax) => tax.id == variants.original?.taxId.toString(),
                  )
                  ?.name ??
              taxes.first.name
          : null;

      formData.add(
        prefix.NewPurchaseFormModel(
          removable: true,
          productId: variants.original?.productId,
          vatPercentage: variants.original?.taxPercentage ?? "",
          productDetailId: variants.id,
          purchaseDetailsId: null,
          productName: variants.name ?? "Unknown Product",
          quantityController: TextEditingController(text: "1"),
          profitMarginController: TextEditingController(
              text: AppConverter.formatNumber(
                  variants.original?.profitMargin ?? "")),
          salePriceController: TextEditingController(
              text: AppConverter.formatNumber(
                  variants.original?.salePrice ?? "")),
          basePriceController: TextEditingController(
              text: AppConverter.formatNumber(
                  variants.original?.basePrice ?? "")),
          purchasePriceController: TextEditingController(
            text: AppConverter.formatNumber(
                variants.original?.purchasePrice.toString() ?? "",
                precision: 2),
          ),
          subTitleVariantText: subTitleVariantText,
          taxType:
              variants.original?.taxType == "1" ? "Exclusive" : "Inclusive",
          selectedTax: selectedTaxType,
          taxId: variants.original?.taxId,
          variantId: variants.original?.variantId,
          discountType:
              variants.original?.discountType == "1" ? "Percent" : "Fixed",
          saleDiscountController: TextEditingController(
              text: AppConverter.formatNumber(
                  variants.original?.discountType == "1"
                      ? variants.original?.discountValue ?? "0"
                      : variants.original?.discountAmount ?? "0")),
        ),
      );
      if (index == -1) {
        calculateUpdateSalePrice(formData.length - 1);
      }
    }

    update(); // Notify listeners or update the UI
  }

  TextEditingController productSearchController = TextEditingController();

  void getProductData() async {
    update();

    ResponseModel responseModel =
        await editPurchaseRepo.getProductsData(productSearchController.text);
    if (responseModel.statusCode == 200) {
      ProductSearchDataResponseModel model =
          productSearchDataResponseModelFromJson(
              jsonEncode(responseModel.responseJson));
      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        productsData = model.data?.products ?? [];

        isLoading = false;
        update();
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    update();
  }

  bool submitLoading = false;

  void submitPurchaseEditData() async {
    submitLoading = true;
    update();

    Map<String, dynamic> body = {
      'purchase_date': dateController.text,
      'supplier_id': supplierId,
      'warehouse_id': warehouseId,
      'reference_number': referenceController.text,
      'status': selectedStatus == "Received"
          ? 1
          : selectedStatus == "Pending"
              ? 2
              : 3,
      'discount_type': selectedPurchaseDiscountType == "Percent" ? 1 : 2,
      'discount': purchaseDiscountController.text,
      'shipping_amount': shippingAmountController.text,
      'paid_amount': supplierPaidAmountController.text,
      'paid_date': paidDateController.text,
      'payment_method_id': paymentMethodId,
      'payment_note': paymentNoteController.text,
    };
    int i = 0;
    for (var v in formData) {
      printW("----------------");
      printW(
        v.discountType == "Percent" ? 1 : 2,
      );
      printW(
        v.saleDiscountController?.text != "0.00"
            ? v.saleDiscountController?.text
            : "",
      );
      printW("----------------");
      body.addAll({
        'purchase_details[$i][product_details_id]': v.productDetailId ?? "",
        'purchase_details[$i][qty]': v.quantityController?.text,
        'purchase_details[$i][base_price]': v.basePriceController?.text ?? "",
        'purchase_details[$i][tax_id]': v.taxId ?? "",
        'purchase_details[$i][purchase_price]': v.purchasePriceController?.text,
        'purchase_details[$i][tax_type]': v.taxType == "Exclusive" ? 1 : 2,
        'purchase_details[$i][purchase_price]': v.purchasePriceController?.text,
        'purchase_details[$i][sale_price]': v.salePriceController?.text,
        'purchase_details[$i][profit_margin]': v.profitMarginController?.text,
        'purchase_details[$i][discount_type]':
            v.discountType == "Percent" ? 1 : 2,
        'purchase_details[$i][discount]':
            v.saleDiscountController?.text != "0.00"
                ? v.saleDiscountController?.text
                : "",
      });

      if (v.purchaseDetailsId != null) {
        body.addAll({
          'purchase_details[$i][purchase_details_id]':
              v.purchaseDetailsId ?? "",
        });
      }
      i++;
    }
    update();

// printE(body);
// return;
    ResponseModel responseModel =
        await editPurchaseRepo.createPurchase(body, selectedFile, purcahseId);

    if (responseModel.statusCode == 200) {
      SubmitNewPurchaseResponseModel model =
          submitNewPurchaseResponseModelFromJson(
              jsonEncode(responseModel.responseJson));

      if (model.status.toString().toLowerCase() == "success") {
        Get.back();
        CustomSnackBar.success(successList: [model.message.toString()]);
      } else {
        CustomSnackBar.error(errorList: model.message ?? ["Request failed"]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }

    submitLoading = false;
    update();
  }

  void initializeDefaultOptions() {
    suppliers.insert(0, Supplier(name: "Select Supplier"));
    paymentMethods.insert(0, PaymentMethod(name: "Select Payment Method"));
    taxes.insert(0, PaymentMethod(name: "Select Tax"));
    warehouses.insert(0, Warehouse(name: "Select Warehouse"));
    // productsData.add(ProductElement(name: "Select Products"));
  }

  void changeSelectedDateOnlyValue(BuildContext context) async {
    DateTime? pickedDate = await showDatePicker(
      context: context,
      initialDate: DateTime.now(),
      firstDate: DateTime(1950),
      lastDate: DateTime.now(),
    );
    if (pickedDate != null) {
      final DateTime selectedDateTime = DateTime(
        pickedDate.year,
        pickedDate.month,
        pickedDate.day,
      );

      var formatedDate = DateConverter.formatDepositTimeWithAmFormat(
          selectedDateTime.toString());
      dateController.text = formatedDate.toString();
      update();
    }
    update();
  }

  void changePaidDateValue(BuildContext context) async {
    DateTime? pickedDate = await showDatePicker(
      context: context,
      initialDate: DateTime.now(),
      firstDate: DateTime(2000),
      lastDate: DateTime(2101),
    );
    if (pickedDate != null) {
      final DateTime selectedDateTime = DateTime(
        pickedDate.year,
        pickedDate.month,
        pickedDate.day,
      );

      var formatedDate = DateConverter.formatDepositTimeWithAmFormat(
          selectedDateTime.toString());
      dateController.text = formatedDate.toString();
      update();
    }
    update();
  }

  double totalSubTotal = 0.0;

  void calculateUpdateSalePrice(int index, {bool isEditingSalePrice = false}) {
    final formDataItem = formData[index];

    double basePrice =
        double.tryParse(formDataItem.basePriceController?.text ?? '0') ?? 0.0;
    double profitMargin =
        double.tryParse(formDataItem.profitMarginController?.text ?? '0') ??
            0.0;
    double vatPercentage =
        double.tryParse(formDataItem.vatPercentage ?? '0') ?? 0.0;

    double salePrice =
        double.tryParse(formDataItem.salePriceController?.text ?? '0') ?? 0.0;
    double discountPrice =
        double.tryParse(formDataItem.saleDiscountController?.text ?? '0') ??
            0.0;
    double productQuantity =
        double.tryParse(formDataItem.quantityController?.text ?? '0') ?? 0.0;
    discountInPercent =
        (formDataItem.discountType ?? selectedDiscountType) == "Percent";

    if (isEditingSalePrice) {
      if (basePrice > 0) {
        double countedVat = (vatPercentage / 100) * basePrice;
        double pp = basePrice +
            (formDataItem.taxType?.toString() == 'Exclusive' ? countedVat : 0);
        double extValue = salePrice - pp;
        profitMargin = (extValue / pp) * 100;

        profitMargin = profitMargin.isFinite ? profitMargin : 0;

        formDataItem.purchasePriceController?.text = pp.toString();

        var subTotalCount = pp * productQuantity;
        formDataItem.subTotalController?.text = subTotalCount.toString();

        update();
      } else {
        profitMargin = 0;
      }

      formDataItem.profitMarginController?.text =
          profitMargin.toStringAsFixed(2);
      double finalPrice = salePrice -
          (discountInPercent
              ? salePrice * (discountPrice / 100)
              : discountPrice);

      formDataItem.finalSalePriceController?.text =
          finalPrice.toStringAsFixed(2);
    } else {
      salePrice = basePrice * (1 + profitMargin / 100);

      if (formDataItem.taxType?.toString() == 'Exclusive') {
        salePrice *= (1 + vatPercentage / 100);
      }

      salePrice = salePrice < 0 ? 0 : salePrice;
      double finalPrice = salePrice -
          (discountInPercent
              ? salePrice * (discountPrice / 100)
              : discountPrice);

      double countedVat = (vatPercentage / 100) * basePrice;
      double pp = basePrice +
          (formDataItem.taxType?.toString() == 'Exclusive' ? countedVat : 0);
      formDataItem.purchasePriceController?.text = pp.toString();
      formDataItem.salePriceController?.text = salePrice.toStringAsFixed(2);
      formDataItem.finalSalePriceController?.text =
          finalPrice.toStringAsFixed(2);

      var subTotalCount = pp * productQuantity;
      formDataItem.subTotalController?.text = subTotalCount.toString();
      formDataItem.finalSalePriceController?.text =
          finalPrice.toStringAsFixed(2);

    }
    calculateTotalSubTotal();
    update();
  }

  void calculateTotalSubTotal() {
    totalSubTotal = 0.0;
    for (var item in formData) {
      double subTotal =
          double.tryParse(item.subTotalController?.text ?? '0') ?? 0.0;
      totalSubTotal += subTotal;
    }
    update();
  }

  double discountAmount = 0.0;
  void calculateTotal() {
    double purchaseDiscount =
        double.tryParse(purchaseDiscountController.text) ?? 0.0;
    double shippingAmount =
        double.tryParse(shippingAmountController.text) ?? 0.0;
    discountInPercent =
        selectedPurchaseDiscountType == "Percent" ? true : false;

    total = totalSubTotal -
        (discountInPercent
            ? (totalSubTotal * (purchaseDiscount / 100))
            : purchaseDiscount);

    total = total + shippingAmount;
    discountAmount = (discountInPercent
        ? (totalSubTotal * (purchaseDiscount / 100))
        : purchaseDiscount);
    update();
  }

  void changeStep() {
    if (step == 0) {
      if (warehouseId != "") {
        step++;
      } else {
        CustomSnackBar.error(errorList: [MyStrings.selectWarehouse.tr]);
      }
    } else if (step == 1) {
      if (formData.isNotEmpty) {
        step++;
        calculateTotal();
      } else {
        CustomSnackBar.error(errorList: [MyStrings.selectProducts.tr]);
      }
    }

    update();
  }

  void previousStep() {
    if (step == 1) {
      step--;
    } else if (step == 2) {
      step--;
    }
    update();
  }
}
