import 'package:get/get.dart';
import 'package:ovosale/data/controller/home/home_controller.dart';
import 'package:ovosale/data/repo/profile/profile_repo.dart';
import 'package:ovosale/data/services/shared_pref_service.dart';

import '../../model/profile/profile_response_model.dart';

class ProfileController extends GetxController {
  ProfileRepo profileRepo;
  ProfileResponseModel model = ProfileResponseModel();

  ProfileController({required this.profileRepo});

  bool loading = false;
  String imageUrl = '';
  String userName = "";
  String userMail = "";
  String userRole = "";
  String userImage = "";

  getData() async {
    loading = true;
    update();
    HomeController homeController = Get.find();
    await homeController.loadDashboardData();

    userName = homeController.adminInfo?.username ?? "";
    userMail = homeController.adminInfo?.email ?? "";
    userRole =
        SharedPreferenceService.getString(SharedPreferenceService.userRole);
    userImage = homeController.adminInfo?.imageSrc ?? "";
    loading = false;
    update();
  }
}
