import 'dart:convert';
import 'dart:io';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:image_picker/image_picker.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/data/controller/home/home_controller.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/model/profile/profile_edit_response_model.dart';
import 'package:ovosale/data/repo/profile/edit_profile_repo.dart';
import 'package:ovosale/data/services/shared_pref_service.dart';
import '../../model/profile/profile_response_model.dart';

class EditProfileController extends GetxController {
  EditProfileRepo editProfileRepo;
  ProfileResponseModel model = ProfileResponseModel();

  EditProfileController({required this.editProfileRepo});

  bool loading = false;
  String imageUrl = '';
  String userName = "";
  String userMail = "";
  String userRole = "";
  String userImage = "";
  File? imageFile;
  final ImagePicker _picker = ImagePicker();

  final FocusNode emailFocusNode = FocusNode();
  final FocusNode usernameFocusNode = FocusNode();

  TextEditingController emailController = TextEditingController();
  TextEditingController usernameController = TextEditingController();

  getData() {
    HomeController homeController = Get.find();

    loading = true;
    update();
    userName = homeController.adminInfo?.username ?? "";
    userMail = homeController.adminInfo?.email ?? "";
    userRole =
        SharedPreferenceService.getString(SharedPreferenceService.userRole);
    userImage = homeController.adminInfo?.imageSrc ?? "";
    imageUrl = homeController.adminInfo?.imageSrc ?? "";

    emailController.text = userMail.toString();
    usernameController.text = userName.toString();
    loading = false;
    update();
  }

  Future<void> selectImage() async {
    final pickedFile = await _picker.pickImage(source: ImageSource.gallery);

    if (pickedFile != null) {
      imageFile = File(pickedFile.path);
      imageUrl = pickedFile.path;
      update();
    }
  }

  bool submitLoading = false;
  void submitProfileData() async {
    submitLoading = true;
    update();

    update();

    ResponseModel responseModel = await editProfileRepo.editProfileRepo(
        usernameController.text, emailController.text, imageFile);

    if (responseModel.statusCode == 200) {
      ProfileEditResponseModel model = profileEditResponseModelFromJson(
          jsonEncode(responseModel.responseJson));

      if (model.status.toString().toLowerCase() == "success") {
        SharedPreferenceService.setString(
            SharedPreferenceService.userFullName, usernameController.text);
        SharedPreferenceService.setString(
            SharedPreferenceService.userEmailKey, emailController.text);
        Get.back();
        CustomSnackBar.success(successList: [model.message.toString()]);
      } else {
        CustomSnackBar.error(errorList: model.message ?? ["Request failed"]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }

    submitLoading = false;
    update();
  }
}
