import 'dart:convert';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/core/helper/string_format_helper.dart';
import 'package:ovosale/core/utils/my_strings.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/model/product/product_response_model.dart';
import 'package:ovosale/data/repo/products/products_repo.dart';
import 'package:ovosale/data/services/shared_pref_service.dart';
import '../../model/profile/profile_response_model.dart';

class ProductsController extends GetxController {
  ProductsRepo productsRepo;
  ProfileResponseModel model = ProfileResponseModel();

  ProductsController({required this.productsRepo});

  List<ProductsData> productsData = [];
  List<ProductsData> filteredProducts = [];
  List<Detail> productDetails = [];
  String categoryImagePath = "";
  bool isLoading = false;

  TextEditingController productSearchController = TextEditingController();

  String searchQuery = '';
  String nextPageUrl = '';

  int currentPage = 1;

  bool hasNext() {
    return nextPageUrl.isNotEmpty && nextPageUrl != 'null' ? true : false;
  }

  void getProductData({bool isPagination = false}) async {
    if (isPagination == false) {
      currentPage = 0;
      isLoading = true;
      update();
    }

    currentPage = currentPage + 1;

    if (currentPage == 1) {
      filteredProducts.clear();
    }

    String pram = "";

    pram += "?page=$currentPage";
    pram += "&search=${productSearchController.text}";

    update();
    ResponseModel responseModel = await productsRepo.getProductsData(pram);
    if (responseModel.statusCode == 200) {
      ProductResponseModel model =
          productResponseModelFromJson(jsonEncode(responseModel.responseJson));
      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        filteredProducts.addAll(model.data?.products?.data ?? []);

        nextPageUrl = model.data?.products?.nextPageUrl ?? "";
        for (var product in productsData) {
          if (product.details != null) {
            productDetails.addAll(product.details!);
          }
        }
        categoryImagePath = model.data?.products?.path ?? "";
        isLoading = false;
        update();
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    isLoading = false;
    update();
  }

  String findMinMaxPriceForProduct(List<Detail> productsList) {
    List<double> prices = productsList
        .map((product) => double.tryParse(product.finalPrice ?? "0") ?? 0)
        .toList();

    if (prices.isEmpty) {
      return ""; // Return default values if no matching product
    }

    double minPrice = prices.reduce((a, b) => a < b ? a : b);
    double maxPrice = prices.reduce((a, b) => a > b ? a : b);
    if (prices.length == 1) {
      return "${SharedPreferenceService.getCurrencySymbol()}$minPrice"; // Return default values if no matching product
    }
    return "${SharedPreferenceService.getCurrencySymbol()}${AppConverter.formatNumber(minPrice.toString())}-${SharedPreferenceService.getCurrencySymbol()}${AppConverter.formatNumber(maxPrice.toString())}";
  }
}
