import 'dart:convert';
import 'package:get/get.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/core/utils/my_strings.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/model/product_details/product_details_data_response_model.dart';
import 'package:ovosale/data/repo/product_details/product_details_repo.dart';
import 'package:ovosale/data/services/shared_pref_service.dart';
import '../../model/profile/profile_response_model.dart';

class ProductDetailsController extends GetxController {
  ProductDetailsRepo productDetailsRepo;
  ProfileResponseModel model = ProfileResponseModel();

  ProductDetailsController({required this.productDetailsRepo});

  String productId = "";

  bool isLoading = false;

  Product? products;
  List<Detail> productDetails = [];
  String categoryImagePath = "";

  String searchQuery = '';
  String defaultCurrency = '';

  void getProductDetailsData() async {
    isLoading = true;
    update();
    ResponseModel responseModel =
        await productDetailsRepo.getProductDetailsRepo(productId);
    if (responseModel.statusCode == 200) {
      ProductDetailsResponseModel model = productDetailsResponseModelFromJson(
          jsonEncode(responseModel.responseJson));
      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        products = model.data?.product;
        productDetails.addAll(model.data?.product?.details ?? []);
        defaultCurrency = SharedPreferenceService.getString(
            SharedPreferenceService.defaultCurrencyKey);
        isLoading = false;
        update();
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    isLoading = false;
    update();
  }
}
