import 'dart:convert';

import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/core/utils/my_strings.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/model/payment_method/payment_method_status_response_model.dart';
import 'package:ovosale/data/repo/payment_method/payment_method_repo.dart';

import '../../model/payment_method/payment_method_update_response_model.dart';
import '../../model/profile/profile_response_model.dart';

class PaymentMethodController extends GetxController {
  ProductMethodRepo paymetMethodRepo;
  ProfileResponseModel model = ProfileResponseModel();

  PaymentMethodController({required this.paymetMethodRepo});

  TextEditingController methodNameController = TextEditingController();
  TextEditingController paymentMethodSearchController = TextEditingController();

  List<PaymentMethodData> paymentMethodData = [];
  List<PaymentMethodData> filteredPaymentMethodData = [];
  String categoryImagePath = "";
  bool isLoading = false;

  String searchQuery = '';
  String nextPageUrl = "";
  int currentPage = 1;

  bool hasNext() {
    return nextPageUrl.isNotEmpty && nextPageUrl != 'null' ? true : false;
  }

  getPaymentMethodData({bool isPagination = false}) async {
    if (isPagination == false) {
      currentPage = 0;
      isLoading = true;
      update();
    }

    currentPage = currentPage + 1;

    if (currentPage == 1) {
      filteredPaymentMethodData.clear();
    }

    String pram = "";

    pram += "?page=$currentPage";
    pram += "&search=${paymentMethodSearchController.text}";

    update();
    ResponseModel responseModel =
        await paymetMethodRepo.getPaymentMethodData(pram);
    if (responseModel.statusCode == 200) {
      PaymentMethodUpdateResponseModel model =
          paymentMethodResponseModelFromJson(
              jsonEncode(responseModel.responseJson));
      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        filteredPaymentMethodData.addAll(model.data?.paymentTypes?.data ?? []);
        nextPageUrl = model.data?.paymentTypes?.nextPageUrl ?? "";

        isLoading = false;
        update();
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    isLoading = false;
    update();
  }

  bool submitLoading = false;
  String paymentMethodUpdateLoadingIndex = "-1";
  void changeStatus(
    String id,
    int index,
    bool value,
  ) async {
    paymentMethodUpdateLoadingIndex = id;
    update();
    ResponseModel responseModel =
        await paymetMethodRepo.paymentMethodStatusChangeData(
      id,
    );

    if (responseModel.statusCode == 200) {
      PaymentMethodStatusResponseModel model =
          paymentMethodStatusResponseModelFromJson(
              jsonEncode(responseModel.responseJson));

      if (model.status.toString().toLowerCase() == "success") {
        if (!value) {
          filteredPaymentMethodData[index].status = "1";
        } else {
          filteredPaymentMethodData[index].status = "0";
        }
        CustomSnackBar.success(successList: [model.message.toString()]);
      } else {
        CustomSnackBar.error(errorList: model.message ?? ["Request failed"]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }

    paymentMethodUpdateLoadingIndex = "-1";

    update();
  }

  String selectedMethodId = "";
  void updateMethod() async {
    submitLoading = true;
    update();
    ResponseModel responseModel =
        await paymetMethodRepo.updatePaymentMethodData(
      selectedMethodId,
      methodNameController.text,
    );

    if (responseModel.statusCode == 200) {
      PaymentMethodStatusResponseModel model =
          paymentMethodStatusResponseModelFromJson(
              jsonEncode(responseModel.responseJson));

      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        getPaymentMethodData();
        Get.back();
        update();
        CustomSnackBar.success(
            successList: model.message ?? [MyStrings.success]);
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    submitLoading = false;
    update();
  }
}
