import 'dart:convert';

import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/model/payment_method/new_payment_method_reponse_model.dart';
import 'package:ovosale/data/repo/payment_method/new_payment_method_repo.dart';

class NewPaymentmethodController extends GetxController {
  NewPaymentmethodRepo newPaymentMethodRepo;
  NewPaymentmethodController({required this.newPaymentMethodRepo});

  TextEditingController methodNameController = TextEditingController();

  bool submitLoading = false;

  void submitMethodData() async {
    submitLoading = true;
    update();

    update();

    ResponseModel responseModel = await newPaymentMethodRepo.createMethodRepo(
      methodNameController.text,
    );

    if (responseModel.statusCode == 200) {
      NewPaymentMethodResponseModel model =
          newPaymentMethodResponseModelFromJson(
              jsonEncode(responseModel.responseJson));

      if (model.status.toString().toLowerCase() == "success") {
        Get.back();
        CustomSnackBar.success(successList: [model.message.toString()]);
      } else {
        CustomSnackBar.error(errorList: model.message ?? ["Request failed"]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }

    submitLoading = false;
    update();
  }
}
