import 'package:flutter/cupertino.dart';
import 'package:get/get.dart';
import 'package:ovosale/data/controller/cart/global_controller.dart';
import 'package:ovosale/data/model/new_sale/new_sale_response_model.dart';
import 'package:ovosale/data/repo/new_sale/new_sale_repo.dart';
import 'package:ovosale/data/services/shared_pref_service.dart';

import '../../../app/components/snack_bar/show_custom_snackbar.dart';
import '../../../core/utils/my_strings.dart';
import '../../model/global/response_model/response_model.dart';
import '../../model/new_sale/required_data_response_model.dart';

class NewSaleController extends GetxController {
  NewSaleRepo newSaleRepo;
  NewSaleController({required this.newSaleRepo});
  String selectedValue = "Option 1";

  DraggableScrollableController draggableScrollableController =
      DraggableScrollableController();

  bool isLoading = false;

  TextEditingController searchController = TextEditingController();
  TextEditingController filterSearchController = TextEditingController();
  List<Category> categoryList = [];
  List<SaleProduct> saleProductList = [];
  List<int> selectedCategories = [];

  GlobalController globalCartCountController = Get.find();

  loadData() async {
    isLoading = true;
    update();

    await globalCartCountController.loadWareHouseData();
    await loadRequiredData();
    await loadProductData();

    isLoading = false;
    update();
  }

  Future<void> loadRequiredData() async {
    ResponseModel responseModel = await newSaleRepo.getRequiredData();

    if (responseModel.statusCode == 200) {
      RequiredDataResponseModel model =
          RequiredDataResponseModel.fromJson(responseModel.responseJson);

      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        categoryList.clear();

        categoryList.addAll(model.data?.categories ?? []);
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
  }

  int page = 1;
  String? nextPageUrl;
  bool isProductLoading = false;

  String searchPram = "";

  Future<void> loadProductData(
      {isChangeWareHouse = false, bool isPaginate = false}) async {
    searchPram = "";
    searchPram +=
        "?warehouse_id=${globalCartCountController.selectedWareHouse.id}";
    searchPram += isChangeWareHouse ? "&change_warehouse_id=true" : "";
    searchPram += "&page=$page";

    if (selectedCategories.isNotEmpty) {
      searchPram += "&&category_id=";
      List.generate(selectedCategories.length, (index) {
        searchPram +=
            "${selectedCategories[index]}${selectedCategories.length - 1 == index ? "" : ","}";
      });
    }

    if (isPaginate == false) {
      saleProductList.clear();
      isProductLoading = true;
    }

    if (isPaginate) {
      page = page + 1;
    }

    update();

    ResponseModel responseModel =
        await newSaleRepo.getNewSalesData(searchPram: searchPram);

    if (responseModel.statusCode == 200) {
      NewSaleResponseModel model =
          NewSaleResponseModel.fromJson(responseModel.responseJson);

      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        nextPageUrl = model.data?.hasMore;
        saleProductList.addAll(model.data?.products ?? []);
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }

    isProductLoading = false;
    update();
  }

  bool hasNext() {
    return nextPageUrl.toString() == "true" ? true : false;
  }

  changeSelectedWareHouse(Warehouse warehouse) async {
    Get.back();

    selectedCategories.clear();
    for (var category in categoryList) {
      if (category.isSelected) category.isSelected = false;
    }

    if (globalCartCountController.selectedWareHouse.id != warehouse.id) {
      globalCartCountController.selectedWareHouse = warehouse;

      SharedPreferenceService.setString(
          SharedPreferenceService.selectedWarehouseKey,
          warehouse.id.toString());

      page = 1;
      await loadProductData(isChangeWareHouse: true);
      await globalCartCountController.getCartCount();
    }
  }

  void onCategorySelect(Category category) async {
    page = 1;
    if (category.isSelected) {
      category.isSelected = false;
      update();
      selectedCategories.removeWhere((element) => element == category.id);
    } else {
      category.isSelected = true;
      update();
      selectedCategories.add(category.id ?? -1);
    }
    await loadProductData();
    update();
  }

  void onSearch() async {
    searchPram = "";

    searchPram +=
        "?warehouse_id=${globalCartCountController.selectedWareHouse.id}";
    searchPram += "&search=${filterSearchController.text}";

    isProductLoading = true;
    update();

    ResponseModel responseModel =
        await newSaleRepo.getNewSalesData(searchPram: searchPram);

    if (responseModel.statusCode == 200) {
      NewSaleResponseModel model =
          NewSaleResponseModel.fromJson(responseModel.responseJson);

      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        saleProductList.clear();

        saleProductList.addAll(model.data?.products ?? []);
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }

    isProductLoading = false;
    update();
  }

  void onClearTextField() {
    filterSearchController.clear();
    loadProductData();
  }

  List<Map<String, String>> dropdownData = [
    {"label": "Option 1"},
    {"label": "Option 2"},
    {"label": "Option 3"},
  ];
}
