import 'dart:convert';
import 'dart:io';

import 'package:file_picker/file_picker.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/core/helper/string_format_helper.dart';
import 'package:ovosale/core/utils/util.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/model/product/add_new_product_response_model.dart';
import 'package:ovosale/data/model/product/update_product_data_response_model.dart'
    as prefix;
import 'package:ovosale/data/repo/new_product/new_product_repo.dart';

import '../../model/product/global_attribute_model.dart';

class NewProductController extends GetxController {
  NewProductRepo newProductRepo;
  NewProductController({required this.newProductRepo});

  // Store multiple selected attributes and variants
  List<Attribute> selectedAttributes = [];
  List<Attribute> selectedUpdateAttributes = [];
  List<Attribute> selectedUpdateVariants = [];
  List<Attribute> selectedVariants = [];
  bool isStep2 = false;
  prefix.Product? productDetails;

  List<prefix.ProductDetail> productdetailsData = [];

  TextEditingController productNameController = TextEditingController();
  TextEditingController productCodeController = TextEditingController();
  TextEditingController productBrandController = TextEditingController();
  TextEditingController productQuantityController = TextEditingController();
  TextEditingController productPriceController = TextEditingController();
  TextEditingController productDescriptionController = TextEditingController();
  TextEditingController salePriceController = TextEditingController();

  // Other existing variables
  String selectedCategory = "Select Category";
  String selectedBrand = "Select Brand";
  String selectedUnit = "Select Unit";
  String selectedTax = "Select Tax";
  String selectedProductType = "Static";
  String selectedTaxType = "Exclusive";
  String selectedDiscountType = "Percent";

  String selectedCategoryId = "";
  String selectedBrandId = "";
  String selectedUnitId = "";
  String selectedVariantId = "";
  String selecteAttributeId = "";

  List<String>? selectedAttributeIds;
  List<String>? selectedDisabledAttributeIds;
  List<String>? selectedDisabledVariantIds;
  List<String>? selectedVariantIds;

  List<ProductDetailsFormModel> formData = [];

  List<Map<String, String>> selectedProductTypeData = [
    {"name": "Static"},
    {"name": "Variable"},
  ];
  List<Map<String, String>> taxTypeData = [
    {"name": "Exclusive"},
    {"name": "Inclusive"},
  ];
  List<Map<String, String>> discountTypeData = [
    {"name": "Percent"},
    {"name": "Fixed"},
  ];

  // Lists for dropdown data
  List<Attribute> categories = [];
  List<Attribute> units = [];
  List<Attribute> brands = [];
  List<Attribute> taxes = [];
  List<Attribute> attributes = [];
  List<Attribute> variant = [];
  List<Attribute> filteredVariants = [];
  bool discountInprcent = false;

  List<Attribute> updateCategories = [];
  List<Attribute> updateUnits = [];
  List<Attribute> updateBrandsData = [];
  List<Attribute> updateTaxes = [];
  List<Attribute> updateAttributes = [];

  File? selectedFile;

  void pickFile() async {
    FilePickerResult? result = await FilePicker.platform.pickFiles(
      allowMultiple: false,
      type: FileType.custom,
      allowedExtensions: ['jpg', 'png', 'jpeg'],
    );

    if (result == null) return;

    selectedFile = File(result.files.single.path!);
    update();
  }

  void removeSelectedFile() {
    selectedFile = null;
    update();
  }

  //add product section

  bool loading = false;
  void getAddProductData() async {
    loading = true;
    clearDataLists();
    initializeDefaultOptions();
    selectedProductType = "Static";
    update();

    ResponseModel responseModel = await newProductRepo.getProductDataRepo();

    if (responseModel.statusCode == 200) {
      AddNewProductResponseModel model = addNewProductResponseModelFromJson(
          jsonEncode(responseModel.responseJson));

      if (model.status.toString().toLowerCase() == "success") {
        categories.addAll(model.data?.categories ?? []);
        attributes.addAll(model.data?.attributes ?? []);
        units.addAll(model.data?.units ?? []);
        brands.addAll(model.data?.brands ?? []);
        taxes.addAll(model.data?.taxes ?? []);

        update();
      } else {
        CustomSnackBar.error(errorList: model.message ?? ["Request failed"]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    loading = false;
    update();
  }

  void calculateSalePrice(int index, {bool isEditingSalePrice = false}) {
    final formDataItem = formData[index];
    double basePrice =
        double.tryParse(formDataItem.basePriceController?.text ?? '0') ?? 0.0;
    double profitMargin =
        double.tryParse(formDataItem.profitMarginController?.text ?? '0') ??
            0.0;
    double vatPercentage =
        double.tryParse(formDataItem.vatPercentage ?? '0') ?? 0.0;
    double salePrice =
        double.tryParse(formDataItem.salePriceController?.text ?? '0') ?? 0.0;
    double discountPrice =
        double.tryParse(formDataItem.discountController?.text ?? '0') ?? 0.0;
    bool discountInPercent = selectedDiscountType == "Percent" ? true : false;

    if (isEditingSalePrice) {
      if (basePrice > 0) {
        double countedVat = (vatPercentage / 100) * basePrice;
        double pp = basePrice +
            (formDataItem.taxType?.toString() == 'Exclusive' ? countedVat : 0);
        double extValue = salePrice - pp;
        profitMargin = (extValue / pp) * 100;

        profitMargin = profitMargin.isFinite ? profitMargin : 0;

        formDataItem.purchasePriceController?.text = pp.toString();
        update();
      } else {
        profitMargin = 0;
      }

      formDataItem.profitMarginController?.text =
          profitMargin.toStringAsFixed(2);
      double finalPrice = salePrice -
          (discountInPercent
              ? salePrice * (discountPrice / 100)
              : discountPrice);

      formDataItem.finalSalePriceController?.text =
          finalPrice.toStringAsFixed(2);
    } else {
      salePrice = basePrice * (1 + profitMargin / 100);

      if (selectedTaxType == 'Exclusive') {
        salePrice *= (1 + vatPercentage / 100);
      }

      salePrice = salePrice < 0 ? 0 : salePrice;
      double finalPrice = salePrice -
          (discountInPercent
              ? salePrice * (discountPrice / 100)
              : discountPrice);

      double countedVat = (vatPercentage / 100) * basePrice;
      double pp = basePrice + (selectedTaxType == 'Exclusive' ? countedVat : 0);
      formDataItem.purchasePriceController?.text = pp.toString();
      formDataItem.salePriceController?.text = salePrice.toStringAsFixed(2);
      formDataItem.finalSalePriceController?.text =
          finalPrice.toStringAsFixed(2);
    }

    update();
  }

  void initializeDefaultOptions() {
    categories.add(Attribute(name: "Select Category"));
    brands.add(Attribute(name: "Select Brand"));
    units.add(Attribute(name: "Select Unit"));
    taxes.add(Attribute(name: "Select Tax"));
    // attributes.add(Attribute(name: "Select an Attribute"));
  }

  bool variantLoading = false;

  void filterVariantsBySelectedIds(List<String> selectedIds) async {
    filteredVariants = [];
    variantLoading = true;
    update();

    List<Attribute> tempFilteredVariants = [];

    for (var attribute in attributes) {
      if (selectedIds.contains(attribute.id.toString())) {
        tempFilteredVariants.addAll(attribute.variants ?? []);
      }
    }

    if (tempFilteredVariants.isNotEmpty) {
      filteredVariants = tempFilteredVariants;
    }

    await Future.delayed(Duration(seconds: 1)).whenComplete(() {
      variantLoading = false;
      update();
    });
  }

  void filterUpdatedVariantsBySelectedIds(List<String> selectedIds) async {
    filteredVariants = [];
    variantLoading = true;
    update();

    for (var attribute in updateAttributes) {
      if (selectedIds.contains(attribute.id.toString())) {
        filteredVariants.addAll(attribute.variants ?? []);
      }
    }

    await Future.delayed(Duration(seconds: 1)).whenComplete(() {
      variantLoading = false;
      update();
    });
  }

  void submitProductData() async {
    submitLoading = true;
    update();
    try {
      Map<String, dynamic> body = {
        'name': productNameController.text,
        'brand_id': selectedBrandId,
        'unit_id': selectedUnitId,
        'category_id': selectedCategoryId,
        'description': productDescriptionController.text,
        'product_type': selectedProductType == "Static" ? 1 : 2,
      };
      int i = 0;

      for (var v in formData) {
        body.addAll({
          'product_detail[$i][sku]': v.sku ?? "",
          'product_detail[$i][base_price]': v.basePriceController?.text,
          'product_detail[$i][tax_id]': v.taxId ?? "",
          'product_detail[$i][tax_type]': v.taxType == "Exclusive" ? 1 : 2,
          'product_detail[$i][purchase_price]': v.purchasePriceController?.text,
          'product_detail[$i][sale_price]': v.salePriceController?.text,
          'product_detail[$i][profit_margin]': v.profitMarginController?.text,
          'product_detail[$i][discount_type]':
              v.discountType == 'Percent' ? 1 : 2,
          'product_detail[$i][discount]': v.discountController?.text == "0"
              ? ""
              : v.discountController?.text,
          'product_detail[$i][alert_quantity]': v.alertQuantity,
        });

        if (selectedProductType != "Static") {
          printW(selectedAttributeIds);
          printE(selectedVariants[i].id);
          printW(i);
          body.addAll({
            // 'product_detail[$i][attribute_id]': selectedAttributeIds?.isEmpty == true ? "" : selectedAttributeIds?[i] ?? "",
            'product_detail[$i][attribute_id]':
                formData.isEmpty ? "" : formData[i].attributeId.toString(),

            'product_detail[$i][variant_id]': selectedVariants[i].id,
          });
        }

        i++;
      }
      update();

      ResponseModel responseModel =
          await newProductRepo.createProduct(body, selectedFile);

      if (responseModel.statusCode == 200) {
        AddNewProductResponseModel model = addNewProductResponseModelFromJson(
            jsonEncode(responseModel.responseJson));

        if (model.status.toString().toLowerCase() == "success") {
          Get.back();
          CustomSnackBar.success(
              successList: model.message ?? ["Product added successfully!"]);
        } else {
          if (model.message != null) {
            model.message?.forEach((v) {
              CustomSnackBar.error(errorList: [v], dismissAll: false);
            });
          }
        }
      } else {
        CustomSnackBar.error(errorList: [responseModel.message.tr]);
      }

      submitLoading = false;
      update();
    } catch (e) {
      printX(e);
      submitLoading = false;
      update();
    }
  }

// update product section

  String updateProductId = "";
  String updateProductBrandId = "";
  String updateProductSelectedUnitId = "";
  String updateProductSelectedCategoryId = "";
  String updateProductSelectedTaxId = "";

  void getUpdateProductData(String id) async {
    loading = true;
    update();

    ResponseModel responseModel =
        await newProductRepo.getUpdateProductDataRepo(id);

    if (responseModel.statusCode == 200) {
      prefix.UpdateProductResponseModel model =
          prefix.updateProductResponseModelFromJson(
              jsonEncode(responseModel.responseJson));

      if (model.status.toString().toLowerCase() == "success") {
        productDetails = model.data?.product;
        updateCategories.add(Attribute(id: "0", name: "Select Category"));
        updateCategories.addAll(model.data?.categories ?? []);
        updateUnits.add(Attribute(id: "0", name: "Select Unit"));
        updateUnits.addAll(model.data?.units ?? []);

        updateBrandsData.add(Attribute(id: "0", name: "Select Brand"));
        updateBrandsData.addAll(model.data?.brands ?? []);

        updateTaxes.add(Attribute(name: "Select Tax"));
        updateTaxes.addAll(model.data?.taxes ?? []);
        productdetailsData.addAll(model.data?.product?.details ?? []);
        updateAttributes.addAll(model.data?.attributes ?? []);
        loadEditProductData(model);
        filterUpdatedVariantsBySelectedIds(selectedAttributeIds ?? []);
        update();
      } else {
        CustomSnackBar.error(errorList: model.message ?? ["Request failed"]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    loading = false;
    update();
  }

  loadEditProductData(prefix.UpdateProductResponseModel model) {
    selectedAttributeIds ??= [];
    selectedDisabledAttributeIds ??= [];
    selectedDisabledVariantIds ??= [];
    selectedVariantIds ??= [];
    selectedProductType =
        model.data?.product?.productType == "1" ? "Static" : "Variable";
    productNameController.text = model.data?.product?.name ?? "";
    productCodeController.text = model.data?.product?.productCode ?? "";
    productDescriptionController.text =
        (model.data?.product?.description == "null" &&
                model.data?.product?.description == null
            ? ""
            : model.data?.product?.description)!;
    updateProductBrandId = model.data?.product?.brandId ?? "";
    updateProductSelectedCategoryId = model.data?.product?.categoryId ?? "";
    updateProductSelectedUnitId = model.data?.product?.unitId ?? "";
    selectedUpdateAttributes = model.data?.product?.details
            ?.map((detail) => detail.attribute)
            .whereType<Attribute>() // Remove null values
            .fold<Map<String, Attribute>>({}, (map, attribute) {
              map[attribute.id.toString()] = attribute;
              return map;
            })
            .values
            .toList() ??
        [];

    selectedUpdateVariants = model.data?.product?.details
            ?.map((detail) {
              if (detail.variant != null) {
                return detail.variant;
              } else {
                printX("No attribute found in this detail");
              }
              return null;
            })
            .where((variant) => variant != null)
            .cast<Attribute>()
            .toList() ??
        [];

    selectedDisabledVariantIds?.addAll(
        selectedUpdateVariants.map((variant) => variant.id.toString()));

    selectedAttributeIds?.addAll(
        selectedUpdateAttributes.map((attribute) => attribute.id.toString()));

    selectedDisabledAttributeIds?.addAll(
        selectedUpdateAttributes.map((attribute) => attribute.id.toString()));

    selectedVariantIds?.addAll(
        selectedUpdateVariants.map((variant) => variant.id.toString()));

    final selectedBrandsData = updateBrandsData.firstWhere(
      (brand) => brand.id == updateProductBrandId,
      orElse: () => Attribute(id: "0", name: "Select Brand"),
    );

    final selectedUnitData = updateUnits.firstWhere(
      (unit) => unit.id == updateProductSelectedUnitId,
      orElse: () => Attribute(id: "0", name: "Select Unit"),
    );

    final selectedCategoryData = updateCategories.firstWhere(
      (category) => category.id == updateProductSelectedCategoryId,
      orElse: () => Attribute(id: "0", name: "Select Category"),
    );
    selectedUnit = selectedUnitData.name ?? "";
    selectedBrand = selectedBrandsData.name ?? "";
    selectedCategory = selectedCategoryData.name ?? "";
    for (prefix.ProductDetail details in productDetails?.details ?? []) {
      String? selectedTax = updateTaxes
          .firstWhere(
            (tax) => tax.id == details.taxId,
            orElse: () => Attribute(
                id: '0', name: 'Select Tax'), // Return a default Attribute
          )
          .name;

      selectedBrandId = selectedBrandsData.id.toString();
      selectedUnitId = selectedUnitData.id.toString();
      selectedCategoryId = selectedCategoryData.id.toString();

      formData.add(ProductDetailsFormModel(
          sku: details.sku,
          productId: details.id,
          variantId: details.variant?.id ?? "",
          variantName: details.variant?.name,
          attributeName: details.attribute?.name ?? "",
          alertQuantity:
              AppConverter.formatNumber(details.alertQuantity.toString()),
          attributeId: details.attribute?.id ?? "",
          basePriceController: TextEditingController(
              text: AppConverter.formatNumber(details.basePrice.toString())),
          profitMarginController: TextEditingController(
              text: AppConverter.formatNumber(details.profitMargin.toString())),
          salePriceController: TextEditingController(
              text: AppConverter.formatNumber(details.salePrice.toString())),
          discountController: TextEditingController(
              text:
                  AppConverter.formatNumber(details.discountAmount.toString())),
          purchasePriceController: TextEditingController(
              text:
                  AppConverter.formatNumber(details.purchasePrice.toString())),
          finalSalePriceController: TextEditingController(
              text: AppConverter.formatNumber(details.finalPrice.toString())),
          taxType: details.taxType == "1" ? "Exclusive" : "Inclusive",
          attributes: details.attribute != null ? [details.attribute!] : null,
          selectedTax: selectedTax,
          taxId: details.taxId,
          discountType: details.discountType == "1" ? 'Percent' : 'Fixed',
          vatPercentage: details.taxPercentage

          //   selectedTax: details.ta
          ));
    }
  }

  String getAttributeName(String attributeId) {
    var attribute = attributes.firstWhere(
      (attr) => attr.id == attributeId,
    );
    return attribute.toString();
  }

  void updateSelectedProduct(
    Attribute? variants,
  ) {
    if (variants == null) return;

    bool alreadySelected = selectedVariants.any((v) => v.id == variants.id);

    if (alreadySelected) {
      // Remove variant & corresponding formData entry
      selectedVariants.removeWhere((v) => v.id == variants.id);
      formData.removeWhere((item) => item.variantId == variants.id);
    } else {
      // Check if formData already contains this variant before adding
      bool formExists = formData.any((item) => item.variantId == variants.id);

      if (!formExists) {
        selectedVariants.add(variants);
        String? attributeName = updateAttributes
            .firstWhere(
              (attr) => attr.id == variants.attributeId,
              orElse: () => Attribute(id: "", name: "Unknown"),
            )
            .name;
        formData.add(ProductDetailsFormModel(
            variantId: variants.id,
            variantName: variants.name,
            attributeName: attributeName,
            attributeId: variants.attributeId));
      }
    }

    update(); // Notify UI
  }

  void updateSelectedAttributes() {
    selectedUpdateAttributes = updateAttributes.where((attribute) {
      if (selectedDisabledAttributeIds != null &&
          selectedDisabledAttributeIds!.contains(attribute.id)) {
        return true;
      }

      filterUpdatedVariantsBySelectedIds(selectedAttributeIds ?? []);
      return selectedAttributeIds?.contains(attribute.id) ?? false;
    }).toList();

    update();
  }

  void updateSelectedVariants() {
    selectedUpdateVariants = filteredVariants.where((attribute) {
      // Check if selectedDisabledAttributeIds is not null and contains the attribute ID
      if (selectedDisabledVariantIds != null &&
          selectedDisabledVariantIds!.contains(attribute.id)) {
        return true;
      }

      return selectedVariantIds?.contains(attribute.id) ?? false;
    }).toList();

    update(); // Notify listeners or update UI
  }

  void updateVariants() {
    selectedVariants = filteredVariants.where((attribute) {
      // Check if selectedDisabledAttributeIds is not null and contains the attribute ID
      if (selectedDisabledVariantIds != null &&
          selectedDisabledVariantIds!.contains(attribute.id)) {
        return true;
      }

      return selectedVariantIds?.contains(attribute.id) ?? false;
    }).toList();

    update();
  }

  double salePrice = 0.0;
  double purchasePrice = 0.0;
  double finalSalePrice = 0.0;
  void calculateUpdateSalePrice(int index, {bool isEditingSalePrice = false}) {
    final formDataItem = formData[index];

    double basePrice =
        double.tryParse(formDataItem.basePriceController?.text ?? '0') ?? 0.0;
    double profitMargin =
        double.tryParse(formDataItem.profitMarginController?.text ?? '0') ??
            0.0;
    double vatPercentage =
        double.tryParse(formDataItem.vatPercentage ?? '0') ?? 0.0;

    double salePrice =
        double.tryParse(formDataItem.salePriceController?.text ?? '0') ?? 0.0;
    double discountPrice =
        double.tryParse(formDataItem.discountController?.text ?? '0') ?? 0.0;
    discountInprcent = formDataItem.discountType == "Percent" ? true : false;

    if (isEditingSalePrice) {
      if (basePrice > 0) {
        double countedVat = (vatPercentage / 100) * basePrice;
        double pp = basePrice +
            (formDataItem.taxType?.toString() == 'Exclusive' ? countedVat : 0);
        double extValue = salePrice - pp;
        profitMargin = (extValue / pp) * 100;

        profitMargin = profitMargin.isFinite ? profitMargin : 0;

        formDataItem.purchasePriceController?.text = pp.toString();
        update();
      } else {
        profitMargin = 0;
      }

      formDataItem.profitMarginController?.text =
          profitMargin.toStringAsFixed(2);
      double finalPrice = salePrice -
          (discountInprcent
              ? salePrice * (discountPrice / 100)
              : discountPrice);

      formDataItem.finalSalePriceController?.text =
          finalPrice.toStringAsFixed(2);
    } else {
      salePrice = basePrice * (1 + profitMargin / 100);

      if (formDataItem.taxType?.toString() == 'Exclusive') {
        salePrice *= (1 + vatPercentage / 100);
      }

      salePrice = salePrice < 0 ? 0 : salePrice;
      double finalPrice = salePrice -
          (discountInprcent
              ? salePrice * (discountPrice / 100)
              : discountPrice);

      double countedVat = (vatPercentage / 100) * basePrice;
      double pp = basePrice +
          (formDataItem.taxType?.toString() == 'Exclusive' ? countedVat : 0);
      formDataItem.purchasePriceController?.text = pp.toString();
      formDataItem.salePriceController?.text = salePrice.toStringAsFixed(2);
      formDataItem.finalSalePriceController?.text =
          finalPrice.toStringAsFixed(2);
    }

    update();
  }

  bool submitLoading = false;
  void submitProductUpdateData() async {
    submitLoading = true;
    update();

    Map<String, dynamic> body = {
      'name': productNameController.text,
      'brand_id': selectedBrandId,
      'unit_id': selectedUnitId,
      'description': productDescriptionController.text,
      'category_id': selectedCategoryId,
    };
    int i = 0;

    for (var v in formData) {
      body.addAll({
        'product_detail[$i][base_price]': v.basePriceController?.text,
        'product_detail[$i][tax_id]': v.taxId ?? "",
        'product_detail[$i][tax_type]': v.taxType == "Exclusive" ? 1 : 2,
        'product_detail[$i][purchase_price]': v.purchasePriceController?.text,
        'product_detail[$i][sale_price]': v.salePriceController?.text,
        'product_detail[$i][profit_margin]': v.profitMarginController?.text,
        'product_detail[$i][final_price]': v.finalSalePriceController?.text,
        'product_detail[$i][discount_type]':
            v.discountType == 'Percent' ? 1 : 2,
        'product_detail[$i][discount]':
            v.discountController?.text == "0" ? "" : v.discountController?.text,
        'product_detail[$i][alert_quantity]': v.alertQuantity,
        'product_detail[$i][variant_id]': v.variantId ?? "",
        'product_detail[$i][attribute_id]': v.attributeId ?? "",
      });

      if (v.productId.toString() != 'null') {
        body.addAll({
          'product_detail[$i][id]': v.productId.toString(),
        });
      }
      i++;
    }

    ResponseModel responseModel =
        await newProductRepo.updateProduct(body, selectedFile, updateProductId);

    if (responseModel.statusCode == 200) {
      AddNewProductResponseModel model = addNewProductResponseModelFromJson(
          jsonEncode(responseModel.responseJson));

      if (model.status.toString().toLowerCase() == "success") {
        Get.back();
        CustomSnackBar.success(successList: [model.message.toString()]);
      } else {
        if (model.message != null) {
          model.message?.forEach((v) {
            CustomSnackBar.error(errorList: [v], dismissAll: false);
          });
        }
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }

    submitLoading = false;
    update();
  }

  void clearDataLists() {
    categories.clear();
    units.clear();
    brands.clear();
    taxes.clear();
    attributes.clear();
    variant.clear();
  }

  void stepChanger() {
    isStep2 = !isStep2;
    update();
  }
}
