import 'dart:convert';
import 'dart:io';

import 'package:file_picker/file_picker.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/data/model/category/submit_category_response_model.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/repo/new_category/new_category_repo.dart';

class NewCategoryController extends GetxController {
  NewCategoryRepo newCategoryRepo;
  NewCategoryController({required this.newCategoryRepo});

  TextEditingController categoryNameController = TextEditingController();

  String selectedValue = "Option 1";

  List<Map<String, String>> dropdownData = [
    {"label": "Option 1"},
    {"label": "Option 2"},
    {"label": "Option 3"},
  ];
  File? selectedFile;

  void pickFile() async {
    FilePickerResult? result = await FilePicker.platform.pickFiles(
      allowMultiple: false, // Allow only one file
      type: FileType.custom,
      allowedExtensions: ['jpg', 'png', 'jpeg'],
    );

    if (result == null) return;

    selectedFile = File(result.files.single.path!);
    update();
  }

  bool submitLoading = false;

  void submitCategoryData() async {
    submitLoading = true;
    update();
    ResponseModel responseModel = await newCategoryRepo.createCategory(
        categoryNameController.text, selectedFile);

    if (responseModel.statusCode == 200) {
      UpdateCategoryResponseModel model = updateCategoryResponseModelFromJson(
          jsonEncode(responseModel.responseJson));

      if (model.status.toString().toLowerCase() == "success") {
        Get.back();
        CustomSnackBar.success(successList: [model.message.toString()]);
      } else {
        CustomSnackBar.error(errorList: model.message ?? ["Request failed"]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }

    submitLoading = false;
    update();
  }

  void removeSelectedFile() {
    selectedFile = null;
    update();
  }
}
