import 'dart:convert';
import 'dart:io';

import 'package:file_picker/file_picker.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/data/model/brand/new_brand_response_model.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/repo/new_brand/new_brand_repo.dart';

class NewBrandController extends GetxController {
  NewBrandRepo newBrandRepo;
  NewBrandController({required this.newBrandRepo});

  TextEditingController brandNameController = TextEditingController();

  File? selectedFile;

  void pickFile() async {
    FilePickerResult? result = await FilePicker.platform.pickFiles(
      allowMultiple: false, // Allow only one file
      type: FileType.custom,
      allowedExtensions: ['jpg', 'png', 'jpeg'],
    );

    if (result == null) return;

    selectedFile = File(result.files.single.path!);
    update();
  }

  bool submitLoading = false;

  void submitBrandData() async {
    submitLoading = true;
    update();

    update();

    ResponseModel responseModel = await newBrandRepo.createBrandRepo(
        brandNameController.text, selectedFile);

    if (responseModel.statusCode == 200) {
      NewBrandResponseModel model =
          newBrandResponseModelFromJson(jsonEncode(responseModel.responseJson));

      if (model.status.toString().toLowerCase() == "success") {
        Get.back();
        CustomSnackBar.success(successList: [model.message.toString()]);
      } else {
        CustomSnackBar.error(errorList: model.message ?? ["Request failed"]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }

    submitLoading = false;
    update();
  }

  void removeSelectedFile() {
    selectedFile = null;
    update();
  }
}
