import 'package:get/get.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/core/route/route.dart';
import 'package:ovosale/core/utils/my_strings.dart';
import 'package:ovosale/data/controller/home/home_controller.dart';
import 'package:ovosale/data/repo/more/more_repo.dart';
import 'package:ovosale/data/services/shared_pref_service.dart';

import '../cart/global_controller.dart';

class MoreController extends GetxController {
  MoreRepo moreRepo;
  MoreController({
    required this.moreRepo,
  });

  String userName = "";
  String userRole = "";
  String userImage = "";
  bool loading = false;

  GlobalController globalController = Get.find();

  getData() async {
    print("came here");
    HomeController homeController = Get.find();
    await globalController.loadData();
    loading = true;
    update();
    userName = homeController.adminInfo?.username ?? "";
    userRole =
        SharedPreferenceService.getString(SharedPreferenceService.userRole);
    print("this is user role$userRole");
    userImage = homeController.adminInfo?.imageSrc ?? "";
    loading = false;
    update();
  }

  bool logoutLoading = false;

  Future<void> logout() async {
    logoutLoading = true;
    update();

    Get.back();

    await moreRepo.logout();
    CustomSnackBar.success(successList: [MyStrings.logoutSuccessMsg]);

    logoutLoading = false;
    update();
    Get.offAllNamed(RouteHelper.loginScreen);
  }
}
