import 'dart:async';
import 'package:fl_chart/fl_chart.dart';
import 'package:get/get.dart';
import 'package:ovosale/core/helper/string_format_helper.dart';
import 'package:ovosale/data/controller/cart/global_controller.dart';
import 'package:ovosale/data/model/dashboard/dashboard_response_model.dart';
import 'package:ovosale/data/model/dashboard/recent_transaction_response_model.dart';
import 'package:ovosale/data/model/dashboard/sales_data_response_model.dart';
import 'package:ovosale/data/model/general_setting/general_setting_response_model.dart';
import 'package:ovosale/data/repo/home/home_repo.dart';
import 'package:ovosale/data/services/shared_pref_service.dart';
import '../../../app/components/snack_bar/show_custom_snackbar.dart';
import '../../../core/utils/util_exporter.dart';
import '../../model/global/response_model/response_model.dart';

class HomeController extends GetxController {
  HomeRepo homeRepo;
  HomeController({required this.homeRepo});
  String isKycVerified = '1';
  bool isLoading = true;

  String defaultCurrencySymbol = "";
  GeneralSettingResponseModel generalSettingResponseModel =
      GeneralSettingResponseModel();

  GlobalController globalController = Get.find();

  Future<void> initialData({bool shouldLoad = true}) async {
    defaultCurrencySymbol = SharedPreferenceService.getCurrencySymbol();

    isLoading = shouldLoad ? true : false;
    update();

    await globalController.loadData();
    await loadDashboardData();
    await getSaleData();
    await getRecentTransactionData();

    isLoading = false;
    update();
  }

  String selectedSalesType = MyStrings.today;
  List<String> salesFilterTypeList = [
    MyStrings.today,
    MyStrings.yesterday,
    MyStrings.last7Days,
    MyStrings.lastThirtyDays
  ];

  String selectedTransactionType = MyStrings.sale;
  List<String> transactionFilterTypeList = [MyStrings.sale, MyStrings.purchase];

  List<String> dates = [];
  List<double> sales = [];
  List<double> purchase = [];
  double maxValue = 0.0;
  User? adminInfo;

  List<BarChartGroupData> barGroups = [];

  Future<void> loadDashboardData() async {
    ResponseModel responseModel = await homeRepo.getDashboardData();

    dates.clear();
    sales.clear();
    purchase.clear();
    barGroups.clear();

    if (responseModel.statusCode == 200) {
      DashboardResponseModel model =
          DashboardResponseModel.fromJson(responseModel.responseJson);
      print("this is response model ${responseModel.responseJson}");
      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        adminInfo = model.data?.user;

        dates.addAll(model.data?.graph?.dates ?? []);
        sales.addAll(
            (model.data?.graph?.sales ?? []).map(AppConverter.toDouble));
        purchase.addAll(
            (model.data?.graph?.purchase ?? []).map(AppConverter.toDouble));

        maxValue = [...sales, ...purchase].reduce((a, b) => a > b ? a : b);

        barGroups = List.generate(dates.length, (index) {
          return makeGroupData(index, sales[index], purchase[index]);
        });
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }

    update();
  }

  final double width = 18;
  BarChartGroupData makeGroupData(int x, double y1, double y2) {
    return BarChartGroupData(
      barsSpace: 4,
      x: x,
      barRods: [
        BarChartRodData(
          toY: y1,
          color: MyColor.getPrimaryColor(),
          width: width,
        ),
        BarChartRodData(
          toY: y2,
          color: MyColor.getSecondaryColor(),
          width: width,
        ),
      ],
    );
  }

  String totalSale = "";
  String totalSaleAmount = "";

  Future<void> getSaleData() async {
    ResponseModel responseModel =
        await homeRepo.getSalesData(filterType: selectedSalesType);

    if (responseModel.statusCode == 200) {
      SalesDataResponseModel model =
          SalesDataResponseModel.fromJson(responseModel.responseJson);

      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        totalSale = model.data?.totalSaleCount ?? "";
        totalSaleAmount = model.data?.totalSaleAmount ?? "";
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }

    update();
  }

  List<RecentTransaction> recentTransactionsList = [];
  Future<void> getRecentTransactionData() async {
    ResponseModel responseModel = await homeRepo.getRecentTransaction(
        trxType: selectedTransactionType.toLowerCase());

    if (responseModel.statusCode == 200) {
      recentTransactionsList.clear();

      RecentTransactionResponseModel model =
          RecentTransactionResponseModel.fromJson(responseModel.responseJson);

      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        recentTransactionsList = model.data?.data ?? [];
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }

    update();
  }
}
