import 'dart:io';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/services/api_service.dart';
import 'package:ovosale/environment.dart';
import '../../../app/components/snack_bar/show_custom_snackbar.dart';
import 'package:path/path.dart' as path;

class AnyFileDownloaderAndOpener {
  bool isPdfDownloadLoading = false;

  Future<void> downloadAnyFile({
    required String url,
    String? fileName,
    String extension = "pdf",
    bool isView = true,
  }) async {
    try {
      String getExtention = path.extension(url).toString() == ""
          ? extension
          : path.extension(url).toString().replaceAll(".", "");
      printE(getExtention);
      // Check storage permissions
      if (await MyUtils().checkAndRequestStoragePermission()) {
        var downloadsDirectory = Directory('/storage/emulated/0/Download');
        var fileNameData = fileName != null
            ? '${Environment.appName}_${fileName}_${DateTime.now().millisecondsSinceEpoch}.$getExtention'
            : '${Environment.appName}_${DateTime.now().millisecondsSinceEpoch}.$getExtention';

        if (downloadsDirectory.existsSync()) {
          final downloadPath = '${downloadsDirectory.path}/$fileNameData';
          printE(downloadPath);
          // Try downloading the file
          try {
            ResponseModel responseModel =
                await ApiService.downloadFile(url: url, savePath: downloadPath);
            if (isView) {
              await MyUtils().openFile(downloadPath, getExtention);
            } else {
              CustomSnackBar.success(successList: [responseModel.message]);
            }
          } catch (e) {
            CustomSnackBar.error(errorList: ["Failed to download file: $e"]);
          }
        } else {
          CustomSnackBar.error(
              errorList: ["Download directory does not exist."]);
        }
      } else {
        CustomSnackBar.error(
            errorList: ["Storage permission is required to download files."]);
      }
    } catch (e) {
      printE(e.toString());
    }
  }
}
