import 'dart:convert';
import 'dart:io';

import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/core/utils/my_strings.dart';
import 'package:ovosale/data/model/expense/create_new_expense_category_response_model.dart';
import 'package:ovosale/data/model/expense/expense_category_data_status_response_model.dart';
import 'package:ovosale/data/model/expense/expense_category_response_model.dart';
import 'package:ovosale/data/model/expense/expense_category_update_response_model.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/repo/expense_category/expense_category_repo.dart';

import '../cart/global_controller.dart';

class ExpenseCategoryController extends GetxController {
  ExpenseCategoryRepo expenseCategoryRepo;
  ExpenseCategoryController({required this.expenseCategoryRepo});

  String expensePurposeId = "";
  String nextPageUrl = "";
  int currentPage = 1;
  File? selectedFile;

  GlobalController globalController = Get.find();

  List<ExpenseData> expenseDataList = [];

  List<ExpenseData> filteredExpenseCategoryData = [];

  TextEditingController expenseCategoryNameController = TextEditingController();
  TextEditingController newExpenseCategoryNameController =
      TextEditingController();
  TextEditingController searchExpenseCategoryController =
      TextEditingController();

  bool isLoading = false;
  String defaultCurrency = "";
  String defaultCurrencySymbol = "";

  bool hasNext() {
    return nextPageUrl.isNotEmpty && nextPageUrl != 'null' ? true : false;
  }

  getExpenseCategoryData({bool isPagination = false}) async {
    if (isPagination == false) {
      currentPage = 0;
      isLoading = true;
      update();
    }

    currentPage = currentPage + 1;

    if (currentPage == 1) {
      filteredExpenseCategoryData.clear();
    }

    String pram = "";

    pram += "?page=$currentPage";
    pram += "&search=${searchExpenseCategoryController.text}";

    update();
    ResponseModel responseModel =
        await expenseCategoryRepo.getExpenseCategoryRepo(pram);
    if (responseModel.statusCode == 200) {
      ExpenseCategoryResponseModel model = expenseCategoryResponseModelFromJson(
          jsonEncode(responseModel.responseJson));
      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        filteredExpenseCategoryData
            .addAll(model.data?.expenseCategories?.data ?? []);
        nextPageUrl = model.data?.expenseCategories?.nextPageUrl ?? "";

        isLoading = false;
        update();
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    isLoading = false;
    update();
  }

  bool statusLoading = false;
  String expenseCategoryUpdateLoadingIndex = "-1";
  void changeStatus(String id, int index, bool value) async {
    expenseCategoryUpdateLoadingIndex = id;
    update();

    update();

    ResponseModel responseModel =
        await expenseCategoryRepo.expenseCategoryStatusChangeData(
      id,
    );

    if (responseModel.statusCode == 200) {
      ExpenseCategoryStatusDataResponseModel model =
          expenseCategoryStatusDataResponseModelFromJson(
              jsonEncode(responseModel.responseJson));

      if (model.status.toString().toLowerCase() == "success") {
        if (!value) {
          filteredExpenseCategoryData[index].status = "1";
        } else {
          filteredExpenseCategoryData[index].status = "0";
        }
        CustomSnackBar.success(successList: [model.message.toString()]);
      } else {
        CustomSnackBar.error(errorList: model.message ?? ["Request failed"]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }

    expenseCategoryUpdateLoadingIndex = "-1";
    update();
  }

  bool isSubmitting = false;
  String selectedExpenseId = "";
  void updateExpense() async {
    isSubmitting = true;
    update();

    ResponseModel responseModel = await expenseCategoryRepo.updateExpenseRepo(
        expenseCategoryNameController.text, selectedExpenseId);

    if (responseModel.statusCode == 200) {
      ExpenseCategoryUpdateResponseModel model =
          expenseCategoryUpdateResponseModelFromJson(
              jsonEncode(responseModel.responseJson));

      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        await getExpenseCategoryData(isPagination: false);
        Get.back();
        CustomSnackBar.success(
            successList: model.message ?? [MyStrings.succeed.tr]);

        update();
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    isSubmitting = false;
    update();
  }

  void createExpenseCategory() async {
    isSubmitting = true;
    update();

    ResponseModel responseModel = await expenseCategoryRepo
        .createNewExpenseCategoryRepo(newExpenseCategoryNameController.text);

    if (responseModel.statusCode == 200) {
      CreateExpenseCategoryResponseModel model =
          createExpenseCategoryResponseModelFromJson(
              jsonEncode(responseModel.responseJson));

      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        Get.back();
        isLoading = false;
        update();
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    isSubmitting = false;
    update();
  }
}
