import 'dart:convert';
import 'dart:io';

import 'package:file_picker/file_picker.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/core/helper/date_converter.dart';
import 'package:ovosale/core/utils/my_strings.dart';
import 'package:ovosale/data/model/expense/expense_category_response_model.dart';
import 'package:ovosale/data/model/expense/expense_model.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/model/payment_method/payment_account_resonse_model.dart';
import 'package:ovosale/data/model/payment_method/payment_method_response_model.dart';
import 'package:ovosale/data/model/variant/create_variant_model.dart';
import 'package:ovosale/data/repo/expense/new_expense_repo.dart';

class NewExpenseController extends GetxController {
  NewExpenseRepo newExpenseRepo;
  NewExpenseController({required this.newExpenseRepo});
  String expensePurposeId = "";
  String variantName = "";
  String selectedValue = "Select one";
  File? selectedFile;
  String paymentMethodId = "";

  List<ExpenseData> expenseDataList = [];

  final TextEditingController expenseDateController = TextEditingController();
  final TextEditingController referenceController = TextEditingController();
  final TextEditingController commentController = TextEditingController();
  final TextEditingController amountController = TextEditingController();
  final TextEditingController expensePurposeController =
      TextEditingController();
  final TextEditingController endController = TextEditingController();
  bool isSubmitting = false;
  List<PaymentMethod> paymentMethodList = [];
  PaymentMethod selectedPaymentMethod = PaymentMethod();
  PaymentAccountModel selectedPaymentAccount = PaymentAccountModel();
  List<PaymentAccountModel> paymentAccountsDataList = [];
  ExpenseDataModel getCustomerData() {
    ExpenseDataModel model = ExpenseDataModel(
      expenseDate: expenseDateController.text,
      methodAccountId: paymentMethodId,
      methodTypeId: selectedPaymentAccount.id.toString(),
      amount: amountController.text,
      attachment: selectedFile,
      comment: commentController.text,
      expensePurpose: expensePurposeId,
      referenceNumber: referenceController.text,
    );
    return model;
  }

  bool isLoading = false;
  getPaymentMethod() async {
    isLoading = true;
    update();

    ResponseModel responseModel = await newExpenseRepo.getPaymentMethod();

    if (responseModel.statusCode == 200) {
      PaymentMethodResponseModel model = PaymentMethodResponseModel.fromJson(
        responseModel.responseJson,
      );

      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        paymentMethodList = model.data?.paymentMethods ?? [];
      } else {
        CustomSnackBar.error(
          errorList: model.message ?? [MyStrings.requestFail.tr],
        );
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }

    isLoading = false;
    update();
  }

  void createExpense() async {
    isSubmitting = true;
    ExpenseDataModel model = getCustomerData();
    update();
    ResponseModel responseModel = await newExpenseRepo.createNewExpenseRepo(
      model,
    );
    if (responseModel.statusCode == 200) {
      CreateVariantResponseModel model = createVariantResponseModelFromJson(
          jsonEncode(responseModel.responseJson));
      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        Get.back();
        isSubmitting = false;
        update();
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    isSubmitting = false;
    update();
  }

  bool loading = false;
  void getExpenseCategoryData() async {
    expenseDataList = [];
    loading = true;
    update();

    ResponseModel responseModel = await newExpenseRepo.getExpenseCategoryRepo();

    if (responseModel.statusCode == 200) {
      ExpenseCategoryResponseModel model = expenseCategoryResponseModelFromJson(
          jsonEncode(responseModel.responseJson));
      await getPaymentMethod();
      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        expenseDataList.add(ExpenseData(name: "Select one"));
        expenseDataList.addAll(model.data?.expenseCategories?.data ?? []);

        update();
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    loading = false;
    update();
  }

  void changeEndSelectedDateOnlyValue(BuildContext context) async {
    var initialDate = DateTime.tryParse(commentController.text);

    DateTime? pickedDate = await showDatePicker(
      context: context,
      initialDate: initialDate,
      firstDate: DateTime(2000),
      lastDate: DateTime(2101),
    );
    if (pickedDate != null) {
      final DateTime selectedDateTime = DateTime(
        pickedDate.year,
        pickedDate.month,
        pickedDate.day,
      );

      var formatedDate = DateConverter.formatDepositTimeWithAmFormat(
          selectedDateTime.toString());
      expenseDateController.text = formatedDate.toString();
      update();
    }
    update();
  }

  int paymentMethodCurrentIndex = -1;
  void changeSelectedPaymentMethod(int index) {
    paymentMethodCurrentIndex = index;
    selectedPaymentMethod = paymentMethodList[index];
    paymentMethodId = selectedPaymentMethod.id.toString();
    selectedPaymentAccount = PaymentAccountModel();
    paymentAccountsDataList.clear();
    paymentAccountsDataList.insert(
        0, PaymentAccountModel(id: null, accountName: MyStrings.selectOne.tr));
    paymentAccountsDataList.addAll(selectedPaymentMethod.paymentAccounts ?? []);
    update();
  }

  void setSelectedPaymentAccount(value) {
    selectedPaymentAccount = value;
    update();
  }

  void pickFile() async {
    FilePickerResult? result = await FilePicker.platform.pickFiles(
      allowMultiple: false, // Allow only one file
      type: FileType.custom,
      allowedExtensions: [
        'jpg',
        'png',
        'jpeg',
      ],
    );

    if (result == null) return;

    selectedFile = File(result.files.single.path!);
    update();
  }

  bool isImage(String path) {
    if (path.contains('.jpg')) {
      return true;
    }
    if (path.contains('.png')) {
      return true;
    }
    if (path.contains('.jpeg')) {
      return true;
    }
    return false;
  }

  bool isXlsx(String path) {
    if (path.contains('.xlsx')) {
      return true;
    }
    if (path.contains('.xls')) {
      return true;
    }
    if (path.contains('.xlx')) {
      return true;
    }
    return false;
  }

  bool isDoc(String path) {
    if (path.contains('.doc')) {
      return true;
    }
    if (path.contains('.docs')) {
      return true;
    }
    return false;
  }

  void removeSelectedFile() {
    selectedFile = null;
    update();
  }
}
