import 'dart:convert';
import 'dart:io';
import 'package:file_picker/file_picker.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/core/helper/date_converter.dart';
import 'package:ovosale/core/helper/string_format_helper.dart';
import 'package:ovosale/core/utils/my_strings.dart';
import 'package:ovosale/data/model/auth/two_factor/two_factor_data_model.dart';
import 'package:ovosale/data/model/coupon/coupon_update_response_model.dart';
import 'package:ovosale/data/model/expense/expense_category_response_model.dart'
    as prefix;
import 'package:ovosale/data/model/expense/expense_data_response_model.dart';
import 'package:ovosale/data/model/expense/expense_model.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/repo/expense/expense_repo.dart';
import 'package:ovosale/data/services/shared_pref_service.dart';

import '../cart/global_controller.dart';

class ExpenseController extends GetxController {
  ExpenseRepo expenseRepo;
  ExpenseController({required this.expenseRepo});

  String selectedValue = "Select one";
  String expensePurposeId = "";

  String nextPageUrl = "";
  int currentPage = 1;
  File? selectedFile;

  List<prefix.ExpenseData> expenseCategoryDataList = [];
  GlobalController globalController = Get.find();

  final TextEditingController expenseDateController = TextEditingController();
  final TextEditingController referenceController = TextEditingController();
  final TextEditingController commentController = TextEditingController();
  final TextEditingController amountController = TextEditingController();
  final TextEditingController expensePurposeController =
      TextEditingController();
  final TextEditingController endController = TextEditingController();
  final TextEditingController searchExpenseController = TextEditingController();

  List<ExpenseListData> filteredExpenseData = [];

  String categoryImagePath = "";

  getData() {
    defaultCurrency = SharedPreferenceService.getString(
      SharedPreferenceService.defaultCurrencyKey,
    );

    update();
  }

  bool hasNext() {
    return nextPageUrl.isNotEmpty && nextPageUrl != 'null' ? true : false;
  }

  bool isLoading = false;
  bool isSubmitting = false;
  String defaultCurrency = "";
  String defaultCurrencySymbol = "";
  TwoFactorCodeModel twoFactorCodeModel = TwoFactorCodeModel();

  getExpenseData({bool isPagination = false}) async {
    if (isPagination == false) {
      currentPage = 0;
      isLoading = true;

      update();
    }

    defaultCurrency = SharedPreferenceService.getString(
        SharedPreferenceService.defaultCurrencyKey);
    defaultCurrencySymbol = SharedPreferenceService.getString(
        SharedPreferenceService.defaultCurrencySymbolKey);
    update();

    currentPage = currentPage + 1;

    if (currentPage == 1) {
      filteredExpenseData.clear();
    }

    String pram = "";

    pram += "?page=$currentPage";
    pram += "&search=${searchExpenseController.text}";

    update();
    ResponseModel responseModel = await expenseRepo.getExpenseDataRepo(pram);
    if (responseModel.statusCode == 200) {
      ExpenseDataResponseModel model = expenseDataResponseModelFromJson(
          jsonEncode(responseModel.responseJson));
      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        filteredExpenseData.addAll(model.data?.expenses?.data ?? []);
        nextPageUrl = model.data?.expenses?.nextPageUrl ?? "";
        await getExpenseCategoryData();

        update();
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    isLoading = false;
    update();
  }

  String getPurposeName(String categoryId) {
    var attribute = expenseCategoryDataList.firstWhere(
      (attr) => attr.id == categoryId,
      orElse: () =>
          prefix.ExpenseData(id: '', name: 'Unknown'), // Return a default value
    );
    return attribute.name.toString();
  }

  getSelectedItemValue(int index) {
    final selectedSupplier = filteredExpenseData[index];
    expenseDateController.text = selectedSupplier.expenseDate.toString();
    amountController.text =
        AppConverter.formatNumber(selectedSupplier.amount.toString());
    expensePurposeController.text =
        selectedSupplier.comment.toString() != "null"
            ? selectedSupplier.comment.toString()
            : "Select one";
    commentController.text = selectedSupplier.comment.toString() != "null"
        ? selectedSupplier.comment.toString()
        : "";
    referenceController.text = selectedSupplier.referenceNo.toString() != "null"
        ? selectedSupplier.referenceNo.toString()
        : "";

    prefix.ExpenseData attribute = expenseCategoryDataList.firstWhere(
      (attribute) => attribute.id == selectedSupplier.categoryId,
      orElse: () => prefix.ExpenseData(id: '0', name: 'Unknown'),
    );

    bool exists = expenseCategoryDataList.any(
      (attr) => attr.name == attribute.name,
    );

    selectedValue = exists
        ? attribute.name.toString()
        : expenseCategoryDataList.first.name.toString();
    expensePurposeId = exists
        ? attribute.id.toString()
        : expenseCategoryDataList.first.id.toString();
  }

  getExpenseCategoryData() async {
    expenseCategoryDataList = [];

    ResponseModel responseModel = await expenseRepo.getExpenseCategoryRepo();

    if (responseModel.statusCode == 200) {
      prefix.ExpenseCategoryResponseModel model =
          prefix.expenseCategoryResponseModelFromJson(
              jsonEncode(responseModel.responseJson));
      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        expenseCategoryDataList.add(prefix.ExpenseData(name: "Select one"));
        expenseCategoryDataList
            .addAll(model.data?.expenseCategories?.data ?? []);
        update();
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    isLoading = false;
    update();
  }

  ExpenseDataModel getFieldData() {
    ExpenseDataModel model = ExpenseDataModel(
        expenseDate: expenseDateController.text,
        amount: amountController.text,
        comment: commentController.text,
        expensePurpose: expensePurposeController.text,
        referenceNumber: referenceController.text,
        attachment: selectedFile);
    return model;
  }

  void updateExpense(String expenseId) async {
    isSubmitting = true;
    ExpenseDataModel model = getFieldData();
    update();

    ResponseModel responseModel =
        await expenseRepo.updateExpenseRepo(model, expenseId, expensePurposeId);

    if (responseModel.statusCode == 200) {
      CouponUpdateResponseModel model = couponUpdateResponseModelFromJson(
          jsonEncode(responseModel.responseJson));

      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        await getExpenseData(isPagination: false);

        Get.back();
        isLoading = false;
        CustomSnackBar.success(
            successList: model.message ?? [MyStrings.succeed]);
        update();
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    isSubmitting = false;
    update();
  }

  void changeEndSelectedDateOnlyValue(BuildContext context) async {
    var initialDate = DateTime.tryParse(commentController.text);

    DateTime? pickedDate = await showDatePicker(
      context: context,
      initialDate: initialDate,
      firstDate: DateTime(2000),
      lastDate: DateTime(2101),
    );
    if (pickedDate != null) {
      final DateTime selectedDateTime = DateTime(
        pickedDate.year,
        pickedDate.month,
        pickedDate.day,
      );

      var formatedDate = DateConverter.formatDepositTimeWithAmFormat(
          selectedDateTime.toString());
      expenseDateController.text = formatedDate.toString();
      update();
    }
    update();
  }

  void pickFile() async {
    FilePickerResult? result = await FilePicker.platform.pickFiles(
      allowMultiple: false, // Allow only one file
      type: FileType.custom,
      allowedExtensions: ['jpg', 'png', 'jpeg', 'docx', 'pdf'],
    );

    if (result == null) return;

    selectedFile = File(result.files.single.path!);
    update();
  }

  bool isImage(String path) {
    if (path.contains('.jpg')) {
      return true;
    }
    if (path.contains('.png')) {
      return true;
    }
    if (path.contains('.jpeg')) {
      return true;
    }
    return false;
  }

  bool isXlsx(String path) {
    if (path.contains('.xlsx')) {
      return true;
    }
    if (path.contains('.xls')) {
      return true;
    }
    if (path.contains('.xlx')) {
      return true;
    }
    return false;
  }

  bool isPdf(String path) {
    if (path.contains('.pdf')) {
      return true;
    }
    if (path.contains('.pdf')) {
      return true;
    }
    return false;
  }

  bool isDoc(String path) {
    if (path.contains('.doc')) {
      return true;
    }
    if (path.contains('.docs')) {
      return true;
    }
    return false;
  }

  void removeSelectedFile() {
    selectedFile = null;
    update();
  }
}
