import 'dart:convert';

import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/core/utils/my_strings.dart';
import 'package:ovosale/core/utils/util.dart';
import 'package:ovosale/data/model/auth/two_factor/two_factor_data_model.dart';
import 'package:ovosale/data/model/customer/customer_data_model.dart';
import 'package:ovosale/data/model/customer/customer_response_model.dart';
import 'package:ovosale/data/model/customer/customer_status_response_model.dart';
import 'package:ovosale/data/model/customer/customer_update_response_model.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/model/tax/tax_data_response_model.dart';
import 'package:ovosale/data/repo/customer/customer_repo.dart';

class CustomerController extends GetxController {
  CustomerRepo customerRepo;
  CustomerController({required this.customerRepo});

  final TextEditingController customerNameController = TextEditingController();
  final TextEditingController emailController = TextEditingController();
  final TextEditingController numberController = TextEditingController();
  final TextEditingController addressController = TextEditingController();
  final TextEditingController cityController = TextEditingController();
  final TextEditingController stateController = TextEditingController();
  final TextEditingController zipController = TextEditingController();
  final TextEditingController postCodeController = TextEditingController();
  final TextEditingController countryController = TextEditingController();
  final TextEditingController customerSearchController =
      TextEditingController();

  Taxes? taxes;
  List<CustomerData> filteredCustomersDataList = [];
  String taxDataImagePath = "";
  final ScrollController scrollController = ScrollController();

  bool isLoading = false;
  bool isSubmitting = false;
  String attributeId = "";
  String selectedValue = "Select one";
  String nextPageUrl = "";
  int currentPage = 1;
  TwoFactorCodeModel twoFactorCodeModel = TwoFactorCodeModel();

  bool hasNext() {
    return nextPageUrl.isNotEmpty && nextPageUrl != 'null' ? true : false;
  }

  getCustomerData({bool isPagination = false}) async {
    if (isPagination == false) {
      currentPage = 0;
      isLoading = true;
      update();
    }

    currentPage = currentPage + 1;

    if (currentPage == 1) {
      filteredCustomersDataList.clear();
    }

    String pram = "";

    pram += "?page=$currentPage";
    pram += "&search=${customerSearchController.text}";

    update();
    ResponseModel responseModel = await customerRepo.getCustomerData(pram);
    if (responseModel.statusCode == 200) {
      CustomerResponseModel model =
          customerResponseModelFromJson(jsonEncode(responseModel.responseJson));
      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        filteredCustomersDataList.addAll(model.data?.customers?.data ?? []);
        nextPageUrl = model.data?.customers?.nextPageUrl ?? "";

        isLoading = false;
        update();
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    isLoading = false;
    update();
  }

  String customerUpdateLoadingIndex = "-1";
  void changeStatus(
    String id,
    int index,
    bool value,
  ) async {
    customerUpdateLoadingIndex = id;

    update();
    printW(value);
    try {
      ResponseModel responseModel =
          await customerRepo.customerStatusChangeData(id);

      if (responseModel.statusCode == 200) {
        CustomerStatusChangeResponseModel model =
            customerStatusChangeResponseModelFromJson(
                jsonEncode(responseModel.responseJson));

        if (model.status.toString().toLowerCase() == "success") {
          // getCustomerData(shouldLoad: false);
          if (!value) {
            filteredCustomersDataList[index].status = "1";
          } else {
            filteredCustomersDataList[index].status = "0";
          }
          update();
          CustomSnackBar.success(successList: [model.message.toString()]);
        } else {
          CustomSnackBar.error(errorList: model.message ?? ["Request failed"]);
        }
      } else {
        CustomSnackBar.error(errorList: [responseModel.message.tr]);
      }
    } catch (e) {
      printE(e);
    }

    customerUpdateLoadingIndex = "-1";

    update();
  }

  getSelectedItemValue(int index) {
    final selectedWarehouse = filteredCustomersDataList[index];
    {
      customerNameController.text = selectedWarehouse.name.toString();
      emailController.text = selectedWarehouse.email.toString();
      numberController.text = selectedWarehouse.mobile.toString();
      addressController.text = selectedWarehouse.address.toString();
      cityController.text = selectedWarehouse.city.toString();
      stateController.text = selectedWarehouse.state.toString();
      zipController.text = selectedWarehouse.zip.toString();
      postCodeController.text = selectedWarehouse.postcode.toString();
      countryController.text = selectedWarehouse.country.toString();
      update();
    }
  }

  CustomerDataModel getFieldData() {
    CustomerDataModel model = CustomerDataModel(
        name: customerNameController.text,
        address: addressController.text,
        city: cityController.text,
        contact: numberController.text,
        country: countryController.text,
        email: emailController.text,
        postcode: postCodeController.text,
        state: stateController.text,
        zip: zipController.text);
    return model;
  }

  void updateCustomer(String taxId) async {
    isSubmitting = true;
    CustomerDataModel model = getFieldData();
    update();

    ResponseModel responseModel =
        await customerRepo.updateCustomerRepo(model, taxId);

    if (responseModel.statusCode == 200) {
      CustomerUpdateResponseModel model = customerUpdateResponseModelFromJson(
          jsonEncode(responseModel.responseJson));

      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        await getCustomerData();
        Get.back();
        update();
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    isSubmitting = false;
    update();
  }
}
