import 'dart:convert';

import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/core/utils/my_strings.dart';
import 'package:ovosale/data/model/customer/customer_data_model.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/model/warehouse/add_warehouse_response_model.dart';
import 'package:ovosale/data/repo/customer/new_customer_repo.dart';

class AddNewCustomerController extends GetxController {
  NewCustomerRepo newCustomerRepo;
  AddNewCustomerController({required this.newCustomerRepo});
  String selectedValue = "Option 1";

  final TextEditingController customerNameController = TextEditingController();
  final TextEditingController emailController = TextEditingController();
  final TextEditingController phoneController = TextEditingController();
  final TextEditingController addressController = TextEditingController();
  final TextEditingController cityController = TextEditingController();
  final TextEditingController stateController = TextEditingController();
  final TextEditingController zipController = TextEditingController();
  final TextEditingController postCodeController = TextEditingController();
  final TextEditingController countryController = TextEditingController();

  List<Map<String, String>> dropdownData = [
    {"label": "Option 1"},
    {"label": "Option 2"},
    {"label": "Option 3"},
  ];

  bool isSubmitting = false;

  CustomerDataModel getCustomerData() {
    CustomerDataModel model = CustomerDataModel(
        name: customerNameController.text,
        address: addressController.text,
        city: cityController.text,
        contact: phoneController.text,
        country: countryController.text,
        email: emailController.text,
        postcode: postCodeController.text,
        state: stateController.text,
        zip: zipController.text);
    return model;
  }

  void createCustomer() async {
    isSubmitting = true;
    CustomerDataModel model = getCustomerData();
    update();

    ResponseModel responseModel =
        await newCustomerRepo.createCustomerRepo(model);

    if (responseModel.statusCode == 200) {
      AddWarehouseResponseModel model = addWarehouseResponseModelFromJson(
          jsonEncode(responseModel.responseJson));

      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        Get.back();
        isSubmitting = false;
        CustomSnackBar.success(
            successList: model.message ?? [MyStrings.success.tr]);

        update();
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    isSubmitting = false;
    update();
  }
}
