import 'dart:convert';

import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/core/helper/date_converter.dart';
import 'package:ovosale/core/helper/string_format_helper.dart';
import 'package:ovosale/core/utils/my_strings.dart';
import 'package:ovosale/data/controller/billing_section/billing_section_controller.dart';
import 'package:ovosale/data/controller/checkout/checkout_controller.dart';
import 'package:ovosale/data/model/auth/two_factor/two_factor_data_model.dart';
import 'package:ovosale/data/model/coupon/coupon_list_response_model.dart';
import 'package:ovosale/data/model/coupon/coupon_response_model.dart';
import 'package:ovosale/data/model/coupon/coupon_status_change_response_model.dart'
    as prefix;
import 'package:ovosale/data/repo/coupon/coupon_repo.dart';
import 'package:ovosale/data/services/shared_pref_service.dart';

import '../../model/coupon/coupon_data_model.dart';
import '../../model/coupon/coupon_success_response_model.dart';
import '../../model/coupon/coupon_update_response_model.dart';
import '../../model/global/response_model/response_model.dart';

class CouponController extends GetxController {
  CouponRepo couponRepo;
  bool isFromSale;
  CouponController({required this.couponRepo, required this.isFromSale});

  final TextEditingController couponNameController = TextEditingController();
  final TextEditingController couponCodeController = TextEditingController();
  final TextEditingController minimumAmountController = TextEditingController();
  final TextEditingController amountController = TextEditingController();
  final TextEditingController maximumUsingTimeController =
      TextEditingController();
  final TextEditingController startFromController = TextEditingController();
  final TextEditingController endController = TextEditingController();
  final TextEditingController descriptionController = TextEditingController();
  final TextEditingController searchCouponController = TextEditingController();

  List<Coupon> couponData = [];
  List<CouponListData> filteredCouponListData = [];

  String selectedValue = "%";
  String discountType = "1";

  String categoryImagePath = "";
  List<Map<String, String>> dropdownData = [];

  getData(int index) {
    selectedValue = filteredCouponListData[index].discountType.toString() == "1"
        ? "%"
        : defaultCurrency;
    defaultCurrency = SharedPreferenceService.getString(
      SharedPreferenceService.defaultCurrencyKey,
    );

    dropdownData = [
      {"label": "%"},
      {"label": defaultCurrency},
    ];
    update();
  }

  bool isLoading = false;
  bool isSubmitting = false;
  String defaultCurrency = "";
  String defaultCurrencySymbol = "";
  TwoFactorCodeModel twoFactorCodeModel = TwoFactorCodeModel();

  void getSaleCouponData() async {
    couponData = [];
    isLoading = true;

    defaultCurrency = SharedPreferenceService.getString(
        SharedPreferenceService.defaultCurrencyKey);
    defaultCurrencySymbol = SharedPreferenceService.getString(
        SharedPreferenceService.defaultCurrencySymbolKey);
    update();

    ResponseModel responseModel = await couponRepo.getSaleCouponData();

    if (responseModel.statusCode == 200) {
      CouponResponseModel model =
          CouponResponseModel.fromJson(responseModel.responseJson);

      couponData.addAll(model.data?.coupons ?? []);

      isLoading = false;
      update();
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    isLoading = false;
    update();
  }

  String nextPageUrl = "";
  bool hasNext() {
    return nextPageUrl.isNotEmpty && nextPageUrl != 'null' ? true : false;
  }

  int currentPage = 0;
  getCouponData({bool isPagination = false}) async {
    if (isPagination == false) {
      currentPage = 0;
      isLoading = true;
      update();
    }
    defaultCurrency = SharedPreferenceService.getString(
        SharedPreferenceService.defaultCurrencyKey);
    defaultCurrencySymbol = SharedPreferenceService.getString(
        SharedPreferenceService.defaultCurrencySymbolKey);
    update();
    currentPage = currentPage + 1;

    if (currentPage == 1) {
      filteredCouponListData.clear();
    }

    String pram = "";

    pram += "?page=$currentPage";
    pram += "&search=${searchCouponController.text}";

    update();
    ResponseModel responseModel = await couponRepo.getCouponData(pram);
    if (responseModel.statusCode == 200) {
      CouponListResponseModel model = couponListResponseModelFromJson(
          jsonEncode(responseModel.responseJson));
      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        filteredCouponListData.addAll(model.data?.coupons?.data ?? []);
        nextPageUrl = model.data?.coupons?.nextPageUrl ?? "";

        isLoading = false;
        update();
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    isLoading = false;
    update();
  }

  bool isCouponLoading = false;
  void applyCoupon({required Coupon coupon, bool isFromField = false}) async {
    CheckoutController checkoutController = Get.find();
    BillingSectionController billingController = Get.find();

    if (isFromSale) {
      coupon.isLoading = true;
      if (isFromField) {
        isCouponLoading = true;
      }
      update();

      ResponseModel responseModel = await couponRepo.applyCoupon(
          coupon: coupon.code ?? "",
          subtotal: Get.find<CheckoutController>().getTotalPayableAmount());

      if (responseModel.statusCode == 200) {
        CouponSuccessResponseModel model =
            CouponSuccessResponseModel.fromJson(responseModel.responseJson);

        if (model.status.toString() ==
            MyStrings.success.toString().toLowerCase()) {
          billingController.couponId = model.data?.couponId ?? "-1";

          if (model.data?.discountType.toString() == "1") {
            double percent = AppConverter.toDouble(model.data?.amount);
            double totalAmount = AppConverter.toDouble(
                checkoutController.getTotalPayableAmount());

            double discountAmount = (totalAmount * percent) / 100;
            billingController.couponAmount = discountAmount;
          } else if (model.data?.discountType.toString() == "2") {
            billingController.couponAmount =
                AppConverter.toDouble(model.data?.amount);
          }

          Get.back();
          CustomSnackBar.success(successList: model.message ?? []);
        } else {
          CustomSnackBar.error(
              errorList: model.message ?? [MyStrings.requestFail.tr]);
        }
      } else {
        CustomSnackBar.error(errorList: [responseModel.message.tr]);
      }

      isCouponLoading = false;
      coupon.isLoading = false;
      update();
    }
  }

  getSelectedItemValue(int index) {
    final selectedWarehouse = filteredCouponListData[index];
    {
      couponNameController.text = selectedWarehouse.name.toString();
      couponCodeController.text = selectedWarehouse.code.toString();
      amountController.text = selectedWarehouse.amount.toString();
      minimumAmountController.text = selectedWarehouse.minimumAmount.toString();
      amountController.text =
          AppConverter.formatNumber(selectedWarehouse.amount.toString());
      maximumUsingTimeController.text =
          selectedWarehouse.maximumUsingTime.toString();
      //  descriptionController.text = selectedWarehouse.description.toString() != "null" ? selectedWarehouse.description.toString() : "";
      startFromController.text = selectedWarehouse.startFrom.toString();
      endController.text = selectedWarehouse.endAt.toString();
    }
  }

  CouponDataModel getFieldData() {
    CouponDataModel model = CouponDataModel(
        couponName: couponNameController.text,
        couponCode: couponCodeController.text,
        amount: amountController.text,
        maxUseTime: maximumUsingTimeController.text,
        discountType: discountType,
        description: descriptionController.text != "null"
            ? descriptionController.text
            : descriptionController.text,
        endAt: endController.text,
        minimumAmount: minimumAmountController.text,
        startFrom: startFromController.text);
    return model;
  }

  void updateCoupon(String couponId) async {
    isSubmitting = true;
    CouponDataModel model = getFieldData();
    update();

    ResponseModel responseModel =
        await couponRepo.updateCoupon(model, couponId);

    if (responseModel.statusCode == 200) {
      CouponUpdateResponseModel model = couponUpdateResponseModelFromJson(
          jsonEncode(responseModel.responseJson));

      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        getCouponData();
        Get.back();
        isLoading = false;
        update();
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    isSubmitting = false;
    update();
  }

  void changeSelectedDateOnlyValue(BuildContext context) async {
    var initialDate = DateTime.tryParse(startFromController.text);

    DateTime? pickedDate = await showDatePicker(
      context: context,
      initialDate: initialDate,
      firstDate: DateTime(2000),
      lastDate: DateTime(2101),
    );
    if (pickedDate != null) {
      final DateTime selectedDateTime = DateTime(
        pickedDate.year,
        pickedDate.month,
        pickedDate.day,
      );

      var formatedDate = DateConverter.formatDepositTimeWithAmFormat(
          selectedDateTime.toString());
      startFromController.text = formatedDate.toString();
      update();
    }
    update();
  }

  void changeEndSelectedDateOnlyValue(BuildContext context) async {
    var initialDate = DateTime.tryParse(endController.text);

    DateTime? pickedDate = await showDatePicker(
      context: context,
      initialDate: initialDate,
      firstDate: DateTime(2000),
      lastDate: DateTime(2101),
    );
    if (pickedDate != null) {
      final DateTime selectedDateTime = DateTime(
        pickedDate.year,
        pickedDate.month,
        pickedDate.day,
      );

      var formatedDate = DateConverter.formatDepositTimeWithAmFormat(
          selectedDateTime.toString());
      endController.text = formatedDate.toString();
      update();
    }
    update();
  }

  String couponUpdateLoadingIndex = "-1";
  void changeStatus(String id, int index, bool value) async {
    couponUpdateLoadingIndex = id;
    update();

    ResponseModel responseModel = await couponRepo.couponStatusChangeData(
      id,
    );

    if (responseModel.statusCode == 200) {
      prefix.CouponStatusChangeResponseModel model =
          prefix.couponStatusChangeResponseModelFromJson(
              jsonEncode(responseModel.responseJson));

      if (model.status.toString().toLowerCase() == "success") {
        if (!value) {
          filteredCouponListData[index].status = "1";
        } else {
          filteredCouponListData[index].status = "0";
        }
        update();
        CustomSnackBar.success(successList: [model.message.toString()]);
      } else {
        CustomSnackBar.error(errorList: model.message ?? ["Request failed"]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    couponUpdateLoadingIndex = "-1";
    update();
  }
}
