import 'dart:convert';

import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/core/helper/date_converter.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/model/coupon/add_new_coupon_response_model.dart';
import 'package:ovosale/data/model/coupon/coupon_data_model.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/repo/coupon/add_new_coupon_repo.dart';
import 'package:ovosale/data/services/shared_pref_service.dart';

class AddNewCouponController extends GetxController {
  AddNewCouponRepo addNewCouponRepo;
  AddNewCouponController({required this.addNewCouponRepo});
  String selectedValue = "%";
  String discountType = "1";

  final TextEditingController couponNameController = TextEditingController();
  final TextEditingController couponCodeController = TextEditingController();
  final TextEditingController minimumAmountController = TextEditingController();
  final TextEditingController amountController = TextEditingController();
  final TextEditingController maximumUsingTimeController =
      TextEditingController();
  final TextEditingController startFromController = TextEditingController();
  final TextEditingController endController = TextEditingController();
  final TextEditingController descriptionController = TextEditingController();

  String defaultCurrency = "";
  List<Map<String, String>> dropdownData = [];

  getData() {
    defaultCurrency = SharedPreferenceService.getString(
      SharedPreferenceService.defaultCurrencyKey,
    );
    dropdownData = [
      {"label": "%"},
      {"label": defaultCurrency},
    ];
    update();
  }

  bool isSubmitting = false;

  CouponDataModel getCouponData() {
    CouponDataModel model = CouponDataModel(
      couponName: couponNameController.text,
      couponCode: couponCodeController.text,
      minimumAmount: minimumAmountController.text,
      discountType: discountType,
      amount: amountController.text,
      startFrom: startFromController.text,
      endAt: endController.text,
      maxUseTime: maximumUsingTimeController.text,
      description: descriptionController.text,
    );
    return model;
  }

  void createCoupon() async {
    isSubmitting = true;
    CouponDataModel model = getCouponData();
    update();

    ResponseModel responseModel =
        await addNewCouponRepo.createNewCouponRepo(model);

    if (responseModel.statusCode == 200) {
      AddNewCouponResponseModel model = addNewCouponResponseModelFromJson(
          jsonEncode(responseModel.responseJson));

      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        Get.back();
        isSubmitting = false;
        CustomSnackBar.success(
            successList: model.message ?? [MyStrings.succeed.tr]);
        update();
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    isSubmitting = false;
    update();
  }

  void changeSelectedDateOnlyValue(BuildContext context) async {
    DateTime? pickedDate = await showDatePicker(
      context: context,
      initialDate: DateTime.now(),
      firstDate: DateTime(2000),
      lastDate: DateTime(2101),
    );
    if (pickedDate != null) {
      final DateTime selectedDateTime = DateTime(
        pickedDate.year,
        pickedDate.month,
        pickedDate.day,
      );

      var formatedDate = DateConverter.formatDepositTimeWithAmFormat(
          selectedDateTime.toString());
      startFromController.text = formatedDate.toString();
      update();
    }
    update();
  }

  void changeEndAtDateOnlyValue(BuildContext context) async {
    DateTime? pickedDate = await showDatePicker(
      context: context,
      initialDate: DateTime.now(),
      firstDate: DateTime(2000),
      lastDate: DateTime(2101),
    );
    if (pickedDate != null) {
      final DateTime selectedDateTime = DateTime(
        pickedDate.year,
        pickedDate.month,
        pickedDate.day,
      );

      var formatedDate = DateConverter.formatDepositTimeWithAmFormat(
          selectedDateTime.toString());
      endController.text = formatedDate.toString();
      update();
    }

    update();
  }
}
