import 'dart:convert';
import 'dart:io';
import 'package:file_picker/file_picker.dart';
import 'package:flutter/material.dart';
import 'package:ovosale/data/model/auth/two_factor/two_factor_data_model.dart';
import 'package:get/get.dart';
import 'package:ovosale/core/utils/my_strings.dart';
import 'package:ovosale/data/model/category/category_model.dart';
import 'package:ovosale/data/model/category/category_status_response_model.dart';
import 'package:ovosale/data/model/category/category_update_response_model.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/data/repo/category/category_repo.dart';

class CategoryController extends GetxController {
  CategoryRepo categoryRepo;
  CategoryController({required this.categoryRepo});

  TextEditingController categoryTextController = TextEditingController();
  TextEditingController searchCategoryController = TextEditingController();
  List<CategoryData> filteredCategories = [];
  String? nextPageUrl;
  int currentPage = 0;

  bool isLoading = false;
  TwoFactorCodeModel twoFactorCodeModel = TwoFactorCodeModel();

  Future<void> getCategory({bool isPagination = false}) async {
    if (isPagination == false) {
      currentPage = 0;
      isLoading = true;
      update();
    }

    currentPage = currentPage + 1;

    if (currentPage == 1) {
      filteredCategories.clear();
    }

    String pram = "";

    pram += "?page=$currentPage";
    pram += "&search=${searchCategoryController.text}";

    ResponseModel responseModel = await categoryRepo.getCategoryData(pram);

    if (responseModel.statusCode == 200) {
      CategoryDataModel model =
          categoryDataModelFromJson(jsonEncode(responseModel.responseJson));

      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        nextPageUrl = model.data?.categories?.nextPageUrl ?? "";
        filteredCategories.addAll(model.data?.categories?.data ?? []);
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    isLoading = false;
    update();
  }

  final ScrollController scrollController = ScrollController();

  bool hasNext() {
    return nextPageUrl != null &&
            nextPageUrl!.isNotEmpty &&
            nextPageUrl != 'null'
        ? true
        : false;
  }

  File? selectedFile;

  void pickFile() async {
    FilePickerResult? result = await FilePicker.platform.pickFiles(
      allowMultiple: false, // Allow only one file
      type: FileType.custom,
      allowedExtensions: ['jpg', 'png', 'jpeg'],
    );

    if (result == null) return;

    selectedFile = File(result.files.single.path!);
    update();
  }

  bool submitLoading = false;

  void updateCategory(String categoryId) async {
    submitLoading = true;
    update();

    ResponseModel responseModel = await categoryRepo.updateCategory(
        categoryTextController.text, categoryId, selectedFile);

    if (responseModel.statusCode == 200) {
      CategoryDataUpdateResponseModel model =
          categoryDataUpdateResponseModelFromJson(
              jsonEncode(responseModel.responseJson));

      if (model.status.toString().toLowerCase() == "success") {
        Get.back();
        await getCategory(isPagination: false);

        categoryTextController.clear();
        removeSelectedFile();
        CustomSnackBar.success(successList: [model.message.toString()]);
      } else {
        CustomSnackBar.error(errorList: model.message ?? ["Request failed"]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }

    submitLoading = false;
    update();
  }

  bool statusLoading = false;
  String categoriesUpdateLoadingIndex = "-1";
  void changeStatus(String id, int index, bool value) async {
    categoriesUpdateLoadingIndex = id;
    update();

    ResponseModel responseModel =
        await categoryRepo.categoryStatusChangeData(id);

    if (responseModel.statusCode == 200) {
      CategoryStatusDataResponseModel model =
          categoryStatusDataResponseModelFromJson(
              jsonEncode(responseModel.responseJson));

      if (model.status.toString().toLowerCase() == "success") {
        if (!value) {
          filteredCategories[index].status = "1";
        } else {
          filteredCategories[index].status = "0";
        }
        CustomSnackBar.success(successList: [model.message.toString()]);
      } else {
        CustomSnackBar.error(errorList: model.message ?? ["Request failed"]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }

    categoriesUpdateLoadingIndex = "-1";
    update();
  }

  void removeSelectedFile() {
    selectedFile = null;
    update();
  }
}
