import 'package:get/get.dart';
import 'package:ovosale/core/utils/util.dart';
import 'package:ovosale/data/model/authorization/authorization_response_model.dart';
import 'package:ovosale/data/model/cart_count/cart_count_response_model.dart';
import 'package:ovosale/data/model/new_sale/new_sale_response_model.dart';
import 'package:ovosale/data/model/permission/assign_permission_response_model.dart';
import 'package:ovosale/data/model/warehouse/warehosue_list_response_model.dart';
import 'package:ovosale/data/repo/cart/globalRepo.dart';
import 'package:ovosale/data/services/shared_pref_service.dart';
import '../../../app/components/snack_bar/show_custom_snackbar.dart';
import '../../../core/utils/my_strings.dart';
import '../../model/global/response_model/response_model.dart';
import '../../model/new_sale/required_data_response_model.dart';

class GlobalController extends GetxController {
  GlobalRepo globalCartCountRepo;
  GlobalController({required this.globalCartCountRepo});

  List<String> assignPermissionList = [];

  loadData() async {
    await loadWareHouseData();
    await getCartCount();
    await getAssignedPermission();
  }

  List<Warehouse> wareHouseList = [];
  Warehouse selectedWareHouse = Warehouse(id: -1);

  int page = 1;
  String? nextPageUrl;
  bool isLoading = true;

  Future<void> loadWareHouseData({isPagination = false}) async {
    if (isPagination) {
      page = page + 1;
    }

    if (page == 1) {
      wareHouseList.clear();
    }

    String pram = "?page=$page";

    ResponseModel responseModel =
        await globalCartCountRepo.getWareHouseData(pram: pram);

    if (responseModel.statusCode == 200) {
      WareHouseListResponseModel model =
          WareHouseListResponseModel.fromJson(responseModel.responseJson);

      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        nextPageUrl = model.data?.warehouses?.nextPageUrl;

        wareHouseList.addAll(model.data?.warehouses?.data ?? []);

        if (wareHouseList.isNotEmpty) {
          String selectedWarehouseKey = SharedPreferenceService.getString(
              SharedPreferenceService.selectedWarehouseKey);

          if (selectedWarehouseKey.isNotEmpty) {
            selectedWareHouse = wareHouseList.firstWhere(
                (element) => element.id.toString() == selectedWarehouseKey);
          } else {
            if (selectedWarehouseKey.isEmpty || selectedWareHouse.id == -1) {
              selectedWareHouse = wareHouseList[0];
            }
          }
        }
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }

    update();
  }

  bool hasNext() {
    return nextPageUrl != null &&
            nextPageUrl!.isNotEmpty &&
            nextPageUrl != 'null'
        ? true
        : false;
  }

  Future<void> addToCart(SaleProduct saleProduct,
      {bool showSnackBar = false}) async {
    try {
      Map<String, String> map = {
        "warehouse_id": selectedWareHouse.id.toString(),
        "sku": saleProduct.sku.toString(),
        "quantity": "1",
      };

      ResponseModel responseModel = await globalCartCountRepo.addToCart(map);

      if (responseModel.statusCode == 200) {
        AuthorizationResponseModel model =
            AuthorizationResponseModel.fromJson(responseModel.responseJson);

        if (model.status.toString() ==
            MyStrings.success.toString().toLowerCase()) {
          await getCartCount();
          if (showSnackBar) {
            CustomSnackBar.success(
                successList: model.message ?? [MyStrings.requestSuccess.tr]);
          }
        } else {
          CustomSnackBar.error(
              errorList: model.message ?? [MyStrings.requestFail.tr]);
        }
      } else {
        CustomSnackBar.error(errorList: [responseModel.message.tr]);
      }
    } catch (e) {
      printE(e);
    }
  }

  String cartCount = "0";
  Future<void> getCartCount() async {
    ResponseModel responseModel = await globalCartCountRepo.getCartCount();

    if (responseModel.statusCode == 200) {
      CartCountResponseModel model =
          CartCountResponseModel.fromJson(responseModel.responseJson);

      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        cartCount = model.data?.cartCount ?? "0";
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    update();
  }

  Future<void> getAssignedPermission() async {
    ResponseModel responseModel =
        await globalCartCountRepo.getAssignPermission();

    if (responseModel.statusCode == 200) {
      AssignPermissionResponseModel model =
          AssignPermissionResponseModel.fromJson(responseModel.responseJson);
      assignPermissionList.clear();

      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        assignPermissionList.addAll(model.data?.assignPermissions ?? []);
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    update();
  }

  bool checkPermission({required featureName, bool isShowSnackBar = true}) {
    if (assignPermissionList.any((element) => element == featureName)) {
      return true;
    } else {
      if (isShowSnackBar) {
        CustomSnackBar.error(errorList: [MyStrings.permissionDeniedMessage.tr]);
      }
      return false;
    }
  }
}
