import 'dart:convert';
import 'dart:io';

import 'package:file_picker/file_picker.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/core/utils/my_strings.dart';
import 'package:ovosale/data/model/brand/brand_response_model.dart';
import 'package:ovosale/data/model/brand/brand_status_chnage_response_model.dart';
import 'package:ovosale/data/model/brand/update_brand_response_model.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/repo/brand/brand_repo.dart';

class BrandController extends GetxController {
  BrandRepo brandRepo;
  BrandController({required this.brandRepo});
  List<BrandData> brandDataList = [];
  List<BrandData> filteredBrandDataList = [];
  String categoryImagePath = "";
  String nextPageUrl = "";
  int currentPage = 1;

  TextEditingController brandNameController = TextEditingController();
  TextEditingController brandSearchController = TextEditingController();

  bool isLoading = false;

  File? selectedFile;

  void pickFile() async {
    FilePickerResult? result = await FilePicker.platform.pickFiles(
      allowMultiple: false, // Allow only one file
      type: FileType.custom,
      allowedExtensions: ['jpg', 'png', 'jpeg'],
    );

    if (result == null) return;

    selectedFile = File(result.files.single.path!);
    update();
  }

  getBrand({bool isPagination = false}) async {
    if (isPagination == false) {
      currentPage = 0;
      isLoading = true;
      update();
    }

    currentPage = currentPage + 1;

    if (currentPage == 1) {
      filteredBrandDataList.clear();
    }

    String pram = "";

    pram += "?page=$currentPage";
    pram += "&search=${brandSearchController.text}";

    update();
    ResponseModel responseModel = await brandRepo.getBrandData(pram);
    if (responseModel.statusCode == 200) {
      BrandResponseModel model =
          brandResponseModelFromJson(jsonEncode(responseModel.responseJson));
      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        filteredBrandDataList.addAll(model.data?.brands?.data ?? []);

        nextPageUrl = model.data?.brands?.nextPageUrl ?? "";

        isLoading = false;
        update();
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    isLoading = false;
    update();
  }

  bool hasNext() {
    return nextPageUrl.isNotEmpty && nextPageUrl != 'null' ? true : false;
  }

  String brandUpdateLoadingIndex = "-1";
  void changeStatus(String id, int index, bool value) async {
    brandUpdateLoadingIndex = id;
    update();

    ResponseModel responseModel = await brandRepo.brandStatusChangeData(
      id,
    );

    if (responseModel.statusCode == 200) {
      BrandStatusChangeResponseModel model =
          brandStatusChangeResponseModelFromJson(
              jsonEncode(responseModel.responseJson));

      if (model.status.toString().toLowerCase() == "success") {
        if (!value) {
          filteredBrandDataList[index].status = "1";
        } else {
          filteredBrandDataList[index].status = "0";
        }
        update();
        CustomSnackBar.success(successList: [model.message.toString()]);
      } else {
        CustomSnackBar.error(errorList: model.message ?? ["Request failed"]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    brandUpdateLoadingIndex = "-1";
    update();
  }

  bool submitLoading = false;

  void updateBrandData(String id) async {
    submitLoading = true;
    update();

    update();

    ResponseModel responseModel = await brandRepo.updateBrandRepo(
        brandNameController.text, id, selectedFile);

    if (responseModel.statusCode == 200) {
      UpdateBrandResponseModel model = updateBrandResponseModelFromJson(
          jsonEncode(responseModel.responseJson));

      if (model.status.toString().toLowerCase() == "success") {
        Get.back();
        await getBrand(isPagination: false);
        removeSelectedFile();
        CustomSnackBar.success(successList: [model.message.toString()]);
      } else {
        CustomSnackBar.error(errorList: model.message ?? ["Request failed"]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }

    submitLoading = false;
    update();
  }

  void removeSelectedFile() {
    selectedFile = null;
    update();
  }
}
