import 'package:flutter/cupertino.dart';
import 'package:get/get.dart';
import 'package:ovosale/core/helper/string_format_helper.dart';
import 'package:ovosale/core/utils/my_strings.dart';
import 'package:ovosale/data/controller/checkout/checkout_controller.dart';
import 'package:ovosale/data/repo/billing_section/billing_section_repo.dart';

import '../../services/shared_pref_service.dart';

class BillingSectionController extends GetxController {
  BillingSectionRepo billingSectionRepo;
  BillingSectionController({required this.billingSectionRepo});

  CheckoutController checkoutController = Get.find();

  TextEditingController discountAmountController = TextEditingController();
  TextEditingController deliveryChargeController = TextEditingController();

  String couponId = "";
  double couponAmount = 0.00;
  double discountAmount = 0.00;
  double deliveryCharge = 0.00;

  String defaultCurrency = "";

  getDefaultCurrency() {
    defaultCurrency = SharedPreferenceService.getCurrencySymbol();
  }

  String getTotal() {
    double subtotal =
        AppConverter.toDouble(checkoutController.getTotalPayableAmount());

    subtotal -= couponAmount;
    subtotal -= discountAmount;
    subtotal += deliveryCharge;

    return AppConverter.formatNumber(subtotal.toString());
  }

  String selectedDiscountType = MyStrings.fixed;
  List<String> discountTypeList = [MyStrings.fixed, MyStrings.percent];

  String discountPercent =
      "0"; // for showing percent in dialog when it selected
  String currentDiscountType = MyStrings
      .fixed; // to keep track what was the last selected type when clicked on apply from dialog
  void onDiscountApplyTap() {
    currentDiscountType = selectedDiscountType;
    if (discountAmountController.text.isNotEmpty) {
      if (selectedDiscountType == MyStrings.fixed) {
        double amount = AppConverter.toDouble(discountAmountController.text);
        discountAmount = amount;
      } else {
        double percent = AppConverter.toDouble(discountAmountController.text);
        discountPercent = percent.toString();
        double totalAmount =
            AppConverter.toDouble(checkoutController.getTotalPayableAmount());
        double amount = (totalAmount * percent) / 100;
        discountAmount = amount;
      }
      update();
      Get.back();
    }
  }

  void onDeliveryChargeApplyTap() {
    if (deliveryChargeController.text.isNotEmpty) {
      double amount = AppConverter.toDouble(deliveryChargeController.text);
      deliveryCharge = amount;
      update();
      Get.back();
    }
  }
}
