import 'package:flutter/cupertino.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/core/route/route.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/model/auth/login/login_response_model.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/repo/auth/login_repo.dart';
import 'package:ovosale/data/services/shared_pref_service.dart';

class LoginController extends GetxController {
  LoginRepo loginRepo;
  LoginController({required this.loginRepo});

  final FocusNode emailFocusNode = FocusNode();
  final FocusNode passwordFocusNode = FocusNode();

  TextEditingController emailController = TextEditingController();
  TextEditingController passwordController = TextEditingController();

  String? email;
  String? password;

  List<String> errors = [];
  bool remember = false;

  void forgetPassword() {
    Get.toNamed(RouteHelper.forgotPasswordScreen);
  }

  bool isSubmitLoading = false;
  void loginUser() async {
    try {
      isSubmitLoading = true;
      update();

      // Call the login API
      ResponseModel model = await loginRepo.loginUser(
        emailController.text.toString(),
        passwordController.text.toString(),
      );

      // Check if the response status code is 200 (success)
      if (model.statusCode == 200) {
        // Parse the response into the LoginResponseModel
        LoginResponseModel loginModel =
            LoginResponseModel.fromJson(model.responseJson);

        // Check if the login status is successful
        if (loginModel.status.toString().toLowerCase() ==
            MyStrings.success.toLowerCase()) {
          // Extract access token, token type, and user details
          String accessToken = loginModel.data?.accessToken ?? "";
          String tokenType = loginModel.data?.tokenType ?? "";
          SharedPreferenceService.setString(SharedPreferenceService.userNameKey,
              loginModel.data?.user?.username ?? "");
          SharedPreferenceService.setString(SharedPreferenceService.userRole,
              loginModel.data?.user?.isStaff == "1" ? "As staff" : "As user");
          SharedPreferenceService.setString(SharedPreferenceService.userImage,
              loginModel.data?.user?.imageSrc ?? "");
          //  User? user = loginModel.data?.user;

          // Handle the next steps based on user status
          await RouteHelper.checkUserStatusAndGoToNextStep(
            // user,
            accessToken: accessToken,
            tokenType: tokenType,
            isRemember: true,
          );
        } else {
          // Show an error if login failed
          CustomSnackBar.error(
            errorList: loginModel.message ?? [MyStrings.loginFailedTryAgain.tr],
          );
        }
      } else {
        // Show an error if the status code is not 200
        CustomSnackBar.error(errorList: [model.message]);
      }
    } catch (e) {
      // Handle any unexpected errors that might occur
      printE('Error during login: $e');

      // Show a generic error message
      CustomSnackBar.error(errorList: [MyStrings.somethingWentWrong.tr]);
    } finally {
      // Reset the loading state
      isSubmitLoading = false;
      update();
    }
  }

  changeRememberMe() {
    remember = !remember;
    update();
  }

  void clearTextField() {
    passwordController.text = '';
    emailController.text = '';

    if (remember) {
      remember = false;
    }
    update();
  }
}
