import 'dart:convert';

import 'package:flutter/cupertino.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/core/utils/my_strings.dart';
import 'package:ovosale/data/model/attribute/attribute_response_model.dart';
import 'package:ovosale/data/model/attribute/attribute_status_change_response_model.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/repo/attribute/attribute_repo.dart';

class AttributeController extends GetxController {
  AttributeRepo attributeRepo;
  AttributeController({required this.attributeRepo});
  List<AttributeData> attributeDataList = [];
  List<AttributeData> filteredAttributeDataList = [];
  String categoryImagePath = "";

  TextEditingController attributeController = TextEditingController();
  TextEditingController searchAttributeController = TextEditingController();

  bool isLoading = false;
  bool isSubmitting = false;

  getAttributes({bool isPagination = false}) async {
    isLoading = true;
    filteredAttributeDataList.clear();
    update();

    String pram = "";
    pram += "?search=${searchAttributeController.text}";

    update();
    ResponseModel responseModel = await attributeRepo.getAttributeData(pram);
    if (responseModel.statusCode == 200) {
      AttributeResponseModel model = attributeResponseModelFromJson(
          jsonEncode(responseModel.responseJson));
      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        filteredAttributeDataList.addAll(model.data?.attributes ?? []);

        isLoading = false;
        update();
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
    isLoading = false;
    update();
  }

  void updateAttribute(String id) async {
    isSubmitting = true;
    update();

    try {
      ResponseModel responseModel =
          await attributeRepo.updateAttribute(attributeController.text, id);

      if (responseModel.statusCode == 200) {
        AttributeResponseModel model = attributeResponseModelFromJson(
            jsonEncode(responseModel.responseJson));

        if (model.status.toString() ==
            MyStrings.success.toString().toLowerCase()) {
          await getAttributes(isPagination: true);
          Get.back();
          isLoading = false;
          CustomSnackBar.success(
              successList: model.message ?? [MyStrings.succeed.tr]);
          update();
        } else {
          CustomSnackBar.error(
              errorList: model.message ?? [MyStrings.requestFail.tr]);
        }
        isSubmitting = false;
        update();
      } else {
        CustomSnackBar.error(errorList: [responseModel.message.tr]);
      }
    } catch (e) {
      isSubmitting = false;
      update();
    }
  }

  String attributeUpdateLoadingIndex = "-1";
  void changeStatus(String id, int index, bool value) async {
    attributeUpdateLoadingIndex = id;
    update();

    ResponseModel responseModel =
        await attributeRepo.attributeStatusChangeData(id);

    if (responseModel.statusCode == 200) {
      AttributeStatusChangeResponseModel model =
          attributeStatusChangeResponseModelFromJson(
              jsonEncode(responseModel.responseJson));

      if (model.status.toString().toLowerCase() == "success") {
        if (!value) {
          filteredAttributeDataList[index].status = "1";
        } else {
          filteredAttributeDataList[index].status = "0";
        }
        CustomSnackBar.success(successList: [model.message.toString()]);
      } else {
        CustomSnackBar.error(errorList: model.message ?? ["Request failed"]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }

    attributeUpdateLoadingIndex = "-1";
    update();
  }
}
