import 'dart:io';

import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/core/utils/my_strings.dart';
import 'package:ovosale/data/model/general_setting/general_setting_response_model.dart';
import 'package:ovosale/data/model/global/response_model/response_model.dart';
import 'package:ovosale/data/repo/account/settings_repo.dart';
import 'package:ovosale/data/services/shared_pref_service.dart';

import '../../model/authorization/authorization_response_model.dart';
import '../../model/profile/profile_response_model.dart';

class SettingsController extends GetxController {
  SettingsRepo settingsRepo;
  ProfileResponseModel model = ProfileResponseModel();

  SettingsController({required this.settingsRepo});

  String imageUrl = '';

  bool isLoading = false;
  TextEditingController companyNameController = TextEditingController();
  TextEditingController emailController = TextEditingController();
  TextEditingController phoneController = TextEditingController();
  TextEditingController addressController = TextEditingController();
  TextEditingController purchaseInvoiceController = TextEditingController();
  TextEditingController saleInvoiceController = TextEditingController();
  TextEditingController productCodePrefixController = TextEditingController();
  TextEditingController stockTransferInvoicePrefixController =
      TextEditingController();

  FocusNode companyNameFocusNode = FocusNode();
  FocusNode emailFocusNode = FocusNode();
  FocusNode phoneFocusNode = FocusNode();
  FocusNode addressFocusNode = FocusNode();
  FocusNode purchaseInvoiceFocusNode = FocusNode();
  FocusNode saleInvoiceFocusNode = FocusNode();
  FocusNode productCodePrefixFocusNode = FocusNode();
  FocusNode stockTransferInvoicePrefixFocusNode = FocusNode();

  File? imageFile;

  bool isCompanySettingsEdit = true;
  bool isPrefixSettingsEdit = true;

  loadProfileInfo({bool forceLoad = true}) async {
    if (forceLoad) {
      isLoading = true;
      update();
    }

    ResponseModel responseModel = await settingsRepo.loadProfileInfo();
    if (responseModel.statusCode == 200) {
      model = ProfileResponseModel.fromJson(responseModel.responseJson);
      if (model.data != null &&
          model.status?.toLowerCase() == MyStrings.success.toLowerCase()) {
        // loadData(model);
      } else {
        isLoading = false;
        update();
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }
  }

  bool user2faIsOne = false;

  void loadData() {
    GeneralSetting? generalSetting =
        SharedPreferenceService.getGeneralSettingData().data?.generalSetting;

    companyNameController.text = generalSetting?.companyInformation?.name ?? "";
    emailController.text = generalSetting?.companyInformation?.email ?? "";
    phoneController.text = generalSetting?.companyInformation?.phone ?? "";
    addressController.text = generalSetting?.companyInformation?.address ?? "";
    purchaseInvoiceController.text =
        generalSetting?.prefixSetting?.purchaseInvoicePrefix ?? "";
    saleInvoiceController.text =
        generalSetting?.prefixSetting?.saleInvoicePrefix ?? "";
    productCodePrefixController.text =
        generalSetting?.prefixSetting?.productCodePrefix ?? "";
    stockTransferInvoicePrefixController.text =
        generalSetting?.prefixSetting?.stockTransferInvoicePrefix ?? "";
    isLoading = false;
    update();
  }

  void onEditCompanySettings() {
    isCompanySettingsEdit = false;
    companyNameFocusNode.requestFocus();
    update();
  }

  void onEditPrefixSettings() {
    isPrefixSettingsEdit = false;
    purchaseInvoiceFocusNode.requestFocus();
    update();
  }

  bool isCompanyUpdateLoading = false;
  bool isPrefixUpdateLoading = false;

  Future<void> updateCompanySettings() async {
    Map<String, String> map = {
      "company_information[name]": companyNameController.text,
      "company_information[email]": emailController.text,
      "company_information[phone]": phoneController.text,
      "company_information[address]": addressController.text,
    };

    isCompanyUpdateLoading = true;
    update();

    ResponseModel responseModel = await settingsRepo.updateCompanySettings(map);

    if (responseModel.statusCode == 200) {
      AuthorizationResponseModel model =
          AuthorizationResponseModel.fromJson(responseModel.responseJson);

      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        loadAndSaveGeneralSettingsData();
        CustomSnackBar.success(successList: model.message ?? []);
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }

    isCompanyUpdateLoading = false;
    update();
  }

  Future<void> updatePrefixSettings() async {
    Map<String, String> map = {
      "product_code_prefix": purchaseInvoiceController.text,
      "purchase_invoice_prefix": saleInvoiceController.text,
      "sale_invoice_prefix": productCodePrefixController.text,
      "stock_transfer_invoice_prefix":
          stockTransferInvoicePrefixController.text,
    };

    isPrefixUpdateLoading = true;
    update();
    ResponseModel responseModel = await settingsRepo.updatePrefixSettings(map);

    if (responseModel.statusCode == 200) {
      AuthorizationResponseModel model =
          AuthorizationResponseModel.fromJson(responseModel.responseJson);

      if (model.status.toString() ==
          MyStrings.success.toString().toLowerCase()) {
        loadAndSaveGeneralSettingsData();
        CustomSnackBar.success(successList: model.message ?? []);
      } else {
        CustomSnackBar.error(
            errorList: model.message ?? [MyStrings.requestFail.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message.tr]);
    }

    isPrefixUpdateLoading = false;
    update();
  }

  loadAndSaveGeneralSettingsData() async {
    ResponseModel response = await settingsRepo.getGeneralSetting();

    if (response.statusCode == 200) {
      GeneralSettingResponseModel model =
          GeneralSettingResponseModel.fromJson(response.responseJson);
      if (model.status?.toLowerCase() == MyStrings.success) {
        await SharedPreferenceService.setGeneralSettingData(model);
      } else {
        List<String> message = [MyStrings.somethingWentWrong];
        CustomSnackBar.error(errorList: model.message ?? message);
      }
    }
  }
}
