import 'package:ovosale/environment.dart';

class UrlContainer {
  static const String domainUrl = Environment.MAIN_API_URL;
  static const String baseUrl = '$domainUrl/api/';

  static const String dashBoardEndPoint = 'dashboard';
  static const String depositHistoryUrl = 'deposit/history';
  static const String depositMethodUrl = 'deposit/methods';
  static const String depositInsertUrl = 'deposit/insert';

  static const String accountDisable = "delete-account";

  static const String notificationEndPoint = 'push-notifications';

  static const String registrationEndPoint = 'register';
  static const String loginEndPoint = 'login';
  static const String logoutUrl = 'logout';
  static const String forgetPasswordEndPoint = 'password/email';
  static const String passwordVerifyEndPoint = 'password/verify-code';
  static const String resetPasswordEndPoint = 'password/reset';
  static const String verify2FAUrl = 'verify-g2fa';

  static const String deviceTokenUrl = 'add-device-token';

  static const String otpVerify = 'otp-verify';
  static const String otpResend = 'otp-resend';

  static const String verifyEmailEndPoint = 'verify-email';
  static const String verifySmsEndPoint = 'verify-mobile';
  static const String resendVerifyCodeEndPoint = 'resend-verify/';
  static const String authorizationCodeEndPoint = 'authorization';

  static const String dashBoardUrl = 'dashboard';
  static const String salesUrl = 'sales-data';
  static const String recentTransactionUrl = 'recent-transactions';
  static const String transactionEndpoint = 'transactions';

  static const String addWithdrawRequestUrl = 'withdraw-request';
  static const String withdrawMethodUrl = 'withdraw-method';
  static const String withdrawRequestConfirm = 'withdraw-request/confirm';
  static const String withdrawHistoryUrl = 'withdraw/history';
  static const String withdrawStoreUrl = 'withdraw/store/';
  static const String withdrawConfirmScreenUrl = 'withdraw/preview/';

  static const String kycFormUrl = 'kyc-form';
  static const String kycSubmitUrl = 'kyc-submit';

  static const String generalSettingEndPoint = 'general-setting';

  static const String privacyPolicyEndPoint = 'policies';
  static const String getProfileEndPoint = 'user-info';
  static const String updateProfileEndPoint = 'profile-setting';
  static const String profileCompleteEndPoint = 'user-data-submit';
  static const String companySettingEndPoint = 'company-setting';
  static const String prefixSettingEndPoint = 'prefix-setting';

  static const String changePasswordEndPoint = 'change-password';
  static const String updatePasswordEndPoint = 'password';
  static const String countryEndPoint = 'get-countries';

  static const String categoryDataEndPoint = 'category/list';
  static const String purchaseDataEndPoint = 'purchase/list';
  static const String getAttachmentDataEndPoint = 'purchase/attachment';
  static const String newPurchaseDataEndPoint = 'purchase/create';
  static const String variantDataEndPoint = 'variant/list';
  static const String brandDataEndPoint = 'brand/list';
  static const String taxDataEndPoint = 'tax/list';
  static const String saleCouponDataEndPoint = 'sales/coupon';
  static const String couponDataEndPoint = 'coupon/list';
  static const String applyCouponEndPoint = 'sales/coupon-apply';
  static const String supplierDataEndPoint = 'supplier/list';
  static const String expenseDataEndPoint = 'expense/list';
  static const String expenseDataCategoryEndPoint = 'expense/category/list';
  static const String customerDataEndPoint = 'customer/list';
  static const String attributeDataEndPoint = 'attribute/list';
  static const String unitDataEndPoint = 'unit/list';
  static const String getDatatoCreateProductEndPoint = 'product/create';
  static const String getDatatoUpdateProductEndPoint = 'product/edit/';
  static const String warehouseDataEndPoint = 'warehouse/list';
  static const String productListDataEndPoint = 'product/list';
  static const String producSearchDataEndPoint = 'product/search?search=';
  static const String editPurchaseDataEndPoint = 'purchase/edit/';
  static const String paymentMethodsDataEndPoint = 'payment-type/list';
  static const String roleDataEndPoint = 'role/list';
  static const String newRoleDataEndPoint = 'role/permission/';
  static const String paymentMethodStatusChangeEndPoint =
      'payment-type/status-change/';
  static const String roleStatusChangeEndPoint = 'role/status-change/';
  static const String categoryStatusChangeEndPoint = 'category/status-change/';
  static const String attributeStatusChangeEndPoint =
      'attribute/status-change/';
  static const String variantStatusChangeEndPoint = 'variant/status-change/';
  static const String warehouseStatusChangeEndPoint =
      'warehouse/status-change/';
  static const String brandStatusChangeEndPoint = 'brand/status-change/';
  static const String customerStatusChangeEndPoint = 'customer/status-change/';
  static const String couponStatusChangeEndPoint = 'coupon/status-change/';
  static const String taxStatusChangeEndPoint = 'tax/status-change/';
  static const String supplierStatusChangeEndPoint = 'supplier/status-change/';
  static const String unitStatusChangeEndPoint = 'unit/status-change/';
  static const String expenseCategoryStatusChangeEndPoint =
      'expense/category/status-change/';
  static const String paymentMethodUpdateEndPoint = 'payment-type/update/';
  static const String roleUpdateEndPoint = 'role/update/';
  static const String rolePermissionUpdateEndPoint = 'role/permission/update/';
  static const String productDetailsEndPoint = 'product/view/';

  //sales
  static const String newSaleEndPoint = 'sales/product-list';
  static const String requiredDataEndPoint = 'sales/required-data';
  static const String addToCartEndPoint = 'sales/add-to-cart';
  static const String cartCountEndPoint = 'sales/cart-count';
  static const String checkoutEndPoint = 'sales/checkout';
  static const String updateQuantityEndPoint = 'sales/cart-qty-update';
  static const String clearCartEndPoint = 'sales/cart-remove';
  static const String paymentMethodEndPoint = 'sales/payment-method';
  static const String saleView = 'sales/view';
  static const String confirmSaleEndPoint = 'sales/create';
  static const String editProfileEndPoint = 'profile';
  static const String downloadPdfEndPoint = 'sales/pdf';
  static const String downloadPurchasePdfEndPoint = 'purchase/pdf';
  static const String saleListEndPoint = 'sales/list';

  //report
  static const String stockReportEndPoint = 'report/stock';
  static const String salesReportEndPoint = 'report/sale';
  static const String purchaseReportEndPoint = 'report/purchase';
  static const String expenseReportEndPoint = 'report/expense';
  static const String profitLossReportEndPoint = 'report/invoice-wise';

  static const String wareHouseEndPoint = 'warehouse/list';

  static const String assignPermissionEndPoint = 'role/assign/permission';

  static const String deviceTokenEndPoint = 'add-device-token';
  static const String languageUrl = 'language/';

  static const String twoFactor = "twofactor";
  static const String twoFactorEnable = "twofactor/enable";
  static const String twoFactorDisable = "twofactor/disable";

  static const String communityGroupsEndPoint = 'community-groups';
  static const String attributeUpdateEndPoint = 'attribute/update/';
  static const String unitUpdateEndPoint = 'unit/update/';
  static const String updateCustomerEndPoint = 'customer/update/';
  static const String variantUpdateEndPoint = 'variant/update/';
  static const String taxUpdateEndPoint = 'tax/update/';
  static const String couponUpdateEndPoint = 'coupon/update/';
  static const String supplierUpdateEndPoint = 'supplier/update/';
  static const String createVariantEndPoint = 'variant/create';
  static const String expenseEndPoint = 'expense/create';
  static const String createExpenseEndPoint = 'expense/create';
  static const String createExpenseCategoryEndPoint = 'expense/category/create';
  static const String updateExpenseEndPoint = 'expense/update';
  static const String updateExpenseCategoryEndPoint =
      'expense/category/update/';
  static const String createTaxEndPoint = 'tax/create';
  static const String createWarehouseEndPoint = 'warehouse/create';
  static const String createProductEndPoint = 'product/create';
  static const String createPurchaseEndPoint = 'purchase/create';
  static const String updatePurchaseEndPoint = 'purchase/update/';
  static const String createPCategoryEndPoint = 'category/create';
  static const String createPaymentMethodEndPoint = 'payment-type/create';
  static const String createBrandEndPoint = 'brand/create';
  static const String createAttributeEndPoint = 'attribute/create';
  static const String createUnitEndPoint = 'unit/create';
  static const String updateBrandEndPoint = 'brand/update/';
  static const String updateCategoryEndPoint = 'category/update/';
  static const String updateProductEndPoint = 'product/update/';
  static const String createCustomerEndPoint = 'customer/create';
  static const String createCouponEndPoint = 'coupon/create';
  static const String newSupplierEndPoint = 'supplier/create';
  static const String updateWarehouseEndPoint = 'warehouse/update';

  static const String countryFlagImageLink =
      'https://flagpedia.net/data/flags/h24/{countryCode}.webp';
  static const String faqEndPoint = 'faq';

  static const String supportImagePath = '$domainUrl/assets/support/';
  static const String withDrawImagePath =
      '$domainUrl/assets/images/withdraw_method/';
}
