import 'package:get/get.dart';
import 'package:ovosale/app/components/bottom-nav-bar/animated_bottom_nav_bar.dart';
import 'package:ovosale/app/screens/account/change-password/change_password_screen.dart';
import 'package:ovosale/app/screens/attribute/attribute_screen.dart';
import 'package:ovosale/app/screens/attribute/new_attribute_screen.dart';
import 'package:ovosale/app/screens/auth/forget_password/forget_password/forget_password.dart';
import 'package:ovosale/app/screens/auth/forget_password/reset_password/reset_password_screen.dart';
import 'package:ovosale/app/screens/auth/forget_password/verify_forget_password/verify_forget_password_screen.dart';
import 'package:ovosale/app/screens/auth/login/login_screen.dart';
import 'package:ovosale/app/screens/bottom_nav_section/more/more_screen.dart';
import 'package:ovosale/app/screens/brands/brands_screen.dart';
import 'package:ovosale/app/screens/brands/new_brand_screen.dart';
import 'package:ovosale/app/screens/category/category_screen.dart';
import 'package:ovosale/app/screens/category/new_category_screen.dart';
import 'package:ovosale/app/screens/checkout/checkout_screen.dart';
import 'package:ovosale/app/screens/coupon/add_new_coupon.dart';
import 'package:ovosale/app/screens/coupon/coupon_screen.dart';
import 'package:ovosale/app/screens/customer/add_new_customer.dart';
import 'package:ovosale/app/screens/customer/customer_screen.dart';
import 'package:ovosale/app/screens/expense/expense_screen.dart';
import 'package:ovosale/app/screens/expense/new_expense_screen.dart';
import 'package:ovosale/app/screens/expense_category/expense_category_screen.dart';
import 'package:ovosale/app/screens/expense_category/new_expense_screen.dart';
import 'package:ovosale/app/screens/language/language_screen.dart';
import 'package:ovosale/app/screens/new_sale/new_sale_screen.dart';
import 'package:ovosale/app/screens/payment_methods/new_payment_method_screen.dart';
import 'package:ovosale/app/screens/payment_methods/payment_method_screen.dart';
import 'package:ovosale/app/screens/products/widgets/update/update_product_screen.dart';
import 'package:ovosale/app/screens/profile/edit_profile/edit_profile_screen.dart';
import 'package:ovosale/app/screens/purchase/edit_purchase/edit_purchsae_screen.dart';
import 'package:ovosale/app/screens/purchase/new_purchase/new_purchase_screen.dart';
import 'package:ovosale/app/screens/purchase/purchase_screen.dart';
import 'package:ovosale/app/screens/qr_code/qr_code_scanner_screen.dart';
import 'package:ovosale/app/screens/role_and_permission/new_role_and_permission/new_role_and_permission_screen.dart';
import 'package:ovosale/app/screens/role_and_permission/role_and_permission/role_and_permission.dart';
import 'package:ovosale/app/screens/report/report_screen.dart';
import 'package:ovosale/app/screens/sale_list/sale_list_screen.dart';
import 'package:ovosale/app/screens/supplier/new_supplier_screen.dart';
import 'package:ovosale/app/screens/supplier/supplier_screen.dart';
import 'package:ovosale/app/screens/tax/new_tax_screen.dart';
import 'package:ovosale/app/screens/tax/tax_screen.dart';
import 'package:ovosale/app/screens/unit/new_unit/new_unit_screen.dart';
import 'package:ovosale/app/screens/unit/unit_screen.dart';
import 'package:ovosale/app/screens/variant/new_variant_screen.dart';
import 'package:ovosale/app/screens/payment/payment_screen.dart';
import 'package:ovosale/app/screens/product_details/product_details_screen.dart';
import 'package:ovosale/app/screens/products/new_product_screen.dart';
import 'package:ovosale/app/screens/products/product_screen.dart';
import 'package:ovosale/app/screens/profile/profile_screen.dart';
import 'package:ovosale/app/screens/splash/splash_screen.dart';
import 'package:ovosale/app/screens/supplier_details/supplier_details_screen.dart';
import 'package:ovosale/app/screens/variant/variant_screen.dart';
import 'package:ovosale/app/screens/warehouse/new_warehouse.dart';
import 'package:ovosale/app/screens/warehouse/warehouse_screen.dart';
import 'package:ovosale/data/services/shared_pref_service.dart';
import 'package:shared_preferences/shared_preferences.dart';
import '../../app/screens/billing/billing_screen.dart';
import '../../app/screens/settings/settings_screen.dart';

class RouteHelper {
  //use screen in screen name and route name
  static const String splashScreen = "/splash_screen";
  static const String onboardScreen = "/onboard_screen";
  static const String loginScreen = "/login_screen";
  static const String forgotPasswordScreen = "/forgot_password_screen";
  static const String changePasswordScreen = "/change_password_screen";
  static const String bottomNavBar = "/bottom_nav_bar";
  static const String verifyPassCodeScreen = "/verify_pass_code_screen";
  static const String twoFactorScreen = "/two-factor-screen";
  static const String resetPasswordScreen = "/reset_pass_screen";
  static const String notificationScreen = "/notification_screen";
  static const String profileScreen = "/profile_screen";
  static const String settingsScreen = "/settings_screen";

  static const String languageScreen = "/languages_screen";
  static const String faqScreen = "/faq-screen";
  static const String notification = "/notifications-screen";
  static const String categoryScreen = "/category-screen";
  static const String productsScreen = "/products-screen";
  static const String brandScreen = "/brand-screen";
  static const String warehouseScreen = "/warehouse-screen";
  static const String newWarehouseScreen = "/new-warehouse-screen";
  static const String newCategoryScreen = "/new-category-screen";
  static const String newVariantScreen = "/new-variant-screen";
  static const String newBrandScreen = "/new-brand-screen";
  static const String newProductScreen = "/new-product-screen";
  static const String newSaleScreen = "/new-sale-screen";
  static const String billingSectionScreen = "/billing-section-screen";
  static const String checkoutScreen = "/checkout-screen";
  static const String paymentScreen = "/payment-screen";
  static const String productDetailsScreen = "/product-details-screen";
  static const String supplierDetailsScreen = "/supplier-details-screen";
  static const String moreScreen = "/more-screen";
  static const String variantScreen = "/variant-screen";
  static const String attributeScreen = "/attribute-screen";
  static const String taxScreen = "/tax-screen";
  static const String newTaxScreen = "/new-tax-screen";
  static const String customerDataScreen = "/customer-data-screen";
  static const String addNewCustomerScreen = "/customer-create";
  static const String couponScreen = "/coupon-screen";
  static const String addNewCouponScreen = "/add-new-coupon-screen";
  static const String supplierScreen = "/supplier-screen";
  static const String newSupplierScreen = "/new-supplier-screen";
  static const String expenseScreen = "/expense-screen";
  static const String newExpenseScreen = "/new-expense-screen";
  static const String purchaseScreen = "/purchase-screen";
  static const String updateProductScreen = "/update-product-screen";
  static const String newAttributeScreen = "/new-attribute-screen";
  static const String paymentMethodScreen = "/payment-method-screen";
  static const String newPurchaseScreen = "/new-purchase-screen";
  static const String editPurchaseScreen = "/edit-purchase-screen";
  static const String qrcodeScannerScreen = "/qrcode-scanner-screen";
  static const String expenseCategoryScreen = "/expense-category-screen";
  static const String newExpenseCategoryScreen = "/new-expense-category-screen";
  static const String unitScreen = "/unit-screen";
  static const String newUnitScreen = "/new-unit-screen";
  static const String saleListScreen = "/sale-list-screen";
  static const String roleAndPermissionScreen = "/role-and-permission-screen";
  static const String newRoleandPermissionScreen = "/new-role-and-permission-screen";
  static const String reportScreen = "/report-screen";
  static const String profileEditScreen = "/profile-edit-screen";
  static const String newPaymentMethodScreen = "/new-payment-method-screen";

  List<GetPage> routes = [
    GetPage(name: splashScreen, page: () => const SplashScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: loginScreen, page: () => const LoginScreen(), transition: Transition.downToUp, fullscreenDialog: true, popGesture: false, transitionDuration: const Duration(milliseconds: 300)),
    GetPage(name: forgotPasswordScreen, page: () => const ForgetPasswordScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: changePasswordScreen, page: () => const ChangePasswordScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: bottomNavBar, page: () => const AnimatedBottomNavBar(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: profileScreen, page: () => const ProfileScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: settingsScreen, page: () => const SettingsScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: verifyPassCodeScreen, page: () => const VerifyForgetPassScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: resetPasswordScreen, page: () => const ResetPasswordScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: languageScreen, page: () => const LanguageScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: categoryScreen, page: () => const CategoryScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: productsScreen, page: () => const ProductScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: brandScreen, page: () => const BrandsScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: warehouseScreen, page: () => const WarehouseScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: newWarehouseScreen, page: () => const NewWarehouseScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: newCategoryScreen, page: () => const NewCategoryScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: newBrandScreen, page: () => const NewBrandScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: newProductScreen, page: () => const NewProductScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: newSaleScreen, page: () => const NewSaleScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: billingSectionScreen, page: () => const BillingSectionScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: checkoutScreen, page: () => const CheckoutScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: paymentScreen, page: () => const PaymentScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: supplierDetailsScreen, page: () => const SupplierDetailsScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: productDetailsScreen, page: () => const ProductDetailsScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: moreScreen, page: () => const MoreScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: variantScreen, page: () => const VariantScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: newVariantScreen, page: () => const NewVariantScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: attributeScreen, page: () => const AttributeScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: taxScreen, page: () => const TaxScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: newTaxScreen, page: () => const NewTaxScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: customerDataScreen, page: () => CustomerScreen(isFromSale: Get.arguments), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: addNewCustomerScreen, page: () => const AddNewCustomerScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: couponScreen, page: () => CouponScreen(isFromSale: Get.arguments), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: addNewCouponScreen, page: () => const AddNewCouponScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: supplierScreen, page: () => const SupplierScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: newSupplierScreen, page: () => const NewSupplierScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: expenseScreen, page: () => const ExpenseScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: newExpenseScreen, page: () => const NewExpenseScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: purchaseScreen, page: () => const PurchaseScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: qrcodeScannerScreen, page: () => const QrCodeScannerScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: updateProductScreen, page: () => const UpdateProductScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: newAttributeScreen, page: () => const NewAttrtibuteScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: paymentMethodScreen, page: () => const PaymentMethodScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: newPurchaseScreen, page: () => const NewPurchaseScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: editPurchaseScreen, page: () => const EditPurchaseScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: expenseCategoryScreen, page: () => const ExpenseCategoryScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: newExpenseCategoryScreen, page: () => const NewExpenseCategoryScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: unitScreen, page: () => const UnitScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: newUnitScreen, page: () => const NewUnitScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: roleAndPermissionScreen, page: () => const RoleAndPermissionScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: newRoleandPermissionScreen, page: () => const NewRoleAndPermissionScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: reportScreen, page: () => const ReportScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: saleListScreen, page: () => const SaleListScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: newPaymentMethodScreen, page: () => const NewPaymentmethodScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
    GetPage(name: profileEditScreen, page: () => const EditProfileScreen(), transitionDuration: const Duration(milliseconds: 400), transition: Transition.fadeIn),
  ];

  static Future<void> checkUserStatusAndGoToNextStep({bool isRemember = false, String accessToken = "", String tokenType = ""}) async {
    SharedPreferences sharedPreferences = await SharedPreferences.getInstance();

    if (isRemember) {
      await sharedPreferences.setBool(SharedPreferenceService.rememberMeKey, true);
    } else {
      await sharedPreferences.setBool(SharedPreferenceService.rememberMeKey, false);
    }

    if (accessToken.isNotEmpty) {
      await SharedPreferenceService.setAccessToken(accessToken);
      await sharedPreferences.setString(SharedPreferenceService.accessTokenType, tokenType);
    }

    Get.offAndToNamed(RouteHelper.bottomNavBar, arguments: [true]);
  }
}
